<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for DataExtensionFieldStorageType EnumType
 * @subpackage Enumerations
 */
class DataExtensionFieldStorageType
{
    /**
     * Constant for value 'Unspecified'
     * @return string 'Unspecified'
     */
    const VALUE_UNSPECIFIED = 'Unspecified';
    /**
     * Constant for value 'Plain'
     * @return string 'Plain'
     */
    const VALUE_PLAIN = 'Plain';
    /**
     * Constant for value 'Obfuscated'
     * @return string 'Obfuscated'
     */
    const VALUE_OBFUSCATED = 'Obfuscated';
    /**
     * Constant for value 'Encrypted'
     * @return string 'Encrypted'
     */
    const VALUE_ENCRYPTED = 'Encrypted';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNSPECIFIED
     * @uses self::VALUE_PLAIN
     * @uses self::VALUE_OBFUSCATED
     * @uses self::VALUE_ENCRYPTED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNSPECIFIED,
            self::VALUE_PLAIN,
            self::VALUE_OBFUSCATED,
            self::VALUE_ENCRYPTED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
