<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for DailyRecurrencePatternTypeEnum EnumType
 * @subpackage Enumerations
 */
class DailyRecurrencePatternTypeEnum
{
    /**
     * Constant for value 'Interval'
     * @return string 'Interval'
     */
    const VALUE_INTERVAL = 'Interval';
    /**
     * Constant for value 'EveryWeekDay'
     * @return string 'EveryWeekDay'
     */
    const VALUE_EVERY_WEEK_DAY = 'EveryWeekDay';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_INTERVAL
     * @uses self::VALUE_EVERY_WEEK_DAY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_INTERVAL,
            self::VALUE_EVERY_WEEK_DAY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
