<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for AutomationTypes EnumType
 * @subpackage Enumerations
 */
class AutomationTypes
{
    /**
     * Constant for value 'scheduled'
     * @return string 'scheduled'
     */
    const VALUE_SCHEDULED = 'scheduled';
    /**
     * Constant for value 'triggered'
     * @return string 'triggered'
     */
    const VALUE_TRIGGERED = 'triggered';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SCHEDULED
     * @uses self::VALUE_TRIGGERED
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SCHEDULED,
            self::VALUE_TRIGGERED,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
