<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for AutomationStatus EnumType
 * @subpackage Enumerations
 */
class AutomationStatus
{
    /**
     * Constant for value 'Error'
     * @return string 'Error'
     */
    const VALUE_ERROR = 'Error';
    /**
     * Constant for value 'BuildingError'
     * @return string 'BuildingError'
     */
    const VALUE_BUILDING_ERROR = 'BuildingError';
    /**
     * Constant for value 'Building'
     * @return string 'Building'
     */
    const VALUE_BUILDING = 'Building';
    /**
     * Constant for value 'Ready'
     * @return string 'Ready'
     */
    const VALUE_READY = 'Ready';
    /**
     * Constant for value 'Running'
     * @return string 'Running'
     */
    const VALUE_RUNNING = 'Running';
    /**
     * Constant for value 'Paused'
     * @return string 'Paused'
     */
    const VALUE_PAUSED = 'Paused';
    /**
     * Constant for value 'Stopped'
     * @return string 'Stopped'
     */
    const VALUE_STOPPED = 'Stopped';
    /**
     * Constant for value 'Scheduled'
     * @return string 'Scheduled'
     */
    const VALUE_SCHEDULED = 'Scheduled';
    /**
     * Constant for value 'AwaitingTrigger'
     * @return string 'AwaitingTrigger'
     */
    const VALUE_AWAITING_TRIGGER = 'AwaitingTrigger';
    /**
     * Constant for value 'InactiveTrigger'
     * @return string 'InactiveTrigger'
     */
    const VALUE_INACTIVE_TRIGGER = 'InactiveTrigger';
    /**
     * Constant for value 'Skipped'
     * @return string 'Skipped'
     */
    const VALUE_SKIPPED = 'Skipped';
    /**
     * Constant for value 'Unknown'
     * @return string 'Unknown'
     */
    const VALUE_UNKNOWN = 'Unknown';
    /**
     * Constant for value 'New'
     * @return string 'New'
     */
    const VALUE_NEW = 'New';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ERROR
     * @uses self::VALUE_BUILDING_ERROR
     * @uses self::VALUE_BUILDING
     * @uses self::VALUE_READY
     * @uses self::VALUE_RUNNING
     * @uses self::VALUE_PAUSED
     * @uses self::VALUE_STOPPED
     * @uses self::VALUE_SCHEDULED
     * @uses self::VALUE_AWAITING_TRIGGER
     * @uses self::VALUE_INACTIVE_TRIGGER
     * @uses self::VALUE_SKIPPED
     * @uses self::VALUE_UNKNOWN
     * @uses self::VALUE_NEW
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ERROR,
            self::VALUE_BUILDING_ERROR,
            self::VALUE_BUILDING,
            self::VALUE_READY,
            self::VALUE_RUNNING,
            self::VALUE_PAUSED,
            self::VALUE_STOPPED,
            self::VALUE_SCHEDULED,
            self::VALUE_AWAITING_TRIGGER,
            self::VALUE_INACTIVE_TRIGGER,
            self::VALUE_SKIPPED,
            self::VALUE_UNKNOWN,
            self::VALUE_NEW,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
