<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for AsyncResponseType EnumType
 * @subpackage Enumerations
 */
class AsyncResponseType
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'email'
     * @return string 'email'
     */
    const VALUE_EMAIL = 'email';
    /**
     * Constant for value 'FTP'
     * @return string 'FTP'
     */
    const VALUE_FTP = 'FTP';
    /**
     * Constant for value 'HTTPPost'
     * @return string 'HTTPPost'
     */
    const VALUE_HTTPPOST = 'HTTPPost';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_EMAIL
     * @uses self::VALUE_FTP
     * @uses self::VALUE_HTTPPOST
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_EMAIL,
            self::VALUE_FTP,
            self::VALUE_HTTPPOST,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
