<?php

namespace App\Library\ExactTarget\EnumType;

/**
 * This class stands for AccountTypeEnum EnumType
 * @subpackage Enumerations
 */
class AccountTypeEnum
{
    /**
     * Constant for value 'None'
     * @return string 'None'
     */
    const VALUE_NONE = 'None';
    /**
     * Constant for value 'EXACTTARGET'
     * @return string 'EXACTTARGET'
     */
    const VALUE_EXACTTARGET = 'EXACTTARGET';
    /**
     * Constant for value 'PRO_CONNECT'
     * @return string 'PRO_CONNECT'
     */
    const VALUE_PRO_CONNECT = 'PRO_CONNECT';
    /**
     * Constant for value 'CHANNEL_CONNECT'
     * @return string 'CHANNEL_CONNECT'
     */
    const VALUE_CHANNEL_CONNECT = 'CHANNEL_CONNECT';
    /**
     * Constant for value 'CONNECT'
     * @return string 'CONNECT'
     */
    const VALUE_CONNECT = 'CONNECT';
    /**
     * Constant for value 'PRO_CONNECT_CLIENT'
     * @return string 'PRO_CONNECT_CLIENT'
     */
    const VALUE_PRO_CONNECT_CLIENT = 'PRO_CONNECT_CLIENT';
    /**
     * Constant for value 'LP_MEMBER'
     * @return string 'LP_MEMBER'
     */
    const VALUE_LP_MEMBER = 'LP_MEMBER';
    /**
     * Constant for value 'DOTO_MEMBER'
     * @return string 'DOTO_MEMBER'
     */
    const VALUE_DOTO_MEMBER = 'DOTO_MEMBER';
    /**
     * Constant for value 'ENTERPRISE_2'
     * @return string 'ENTERPRISE_2'
     */
    const VALUE_ENTERPRISE_2 = 'ENTERPRISE_2';
    /**
     * Constant for value 'BUSINESS_UNIT'
     * @return string 'BUSINESS_UNIT'
     */
    const VALUE_BUSINESS_UNIT = 'BUSINESS_UNIT';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_NONE
     * @uses self::VALUE_EXACTTARGET
     * @uses self::VALUE_PRO_CONNECT
     * @uses self::VALUE_CHANNEL_CONNECT
     * @uses self::VALUE_CONNECT
     * @uses self::VALUE_PRO_CONNECT_CLIENT
     * @uses self::VALUE_LP_MEMBER
     * @uses self::VALUE_DOTO_MEMBER
     * @uses self::VALUE_ENTERPRISE_2
     * @uses self::VALUE_BUSINESS_UNIT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NONE,
            self::VALUE_EXACTTARGET,
            self::VALUE_PRO_CONNECT,
            self::VALUE_CHANNEL_CONNECT,
            self::VALUE_CONNECT,
            self::VALUE_PRO_CONNECT_CLIENT,
            self::VALUE_LP_MEMBER,
            self::VALUE_DOTO_MEMBER,
            self::VALUE_ENTERPRISE_2,
            self::VALUE_BUSINESS_UNIT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
