<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Immediate StructType
 * @subpackage Structs
 */
class Immediate extends AbstractStructBase
{
    /**
     * The Entity
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Entity;
    /**
     * The UserID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $UserID;
    /**
     * The Password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * The XMLData
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $XMLData;
    /**
     * Constructor method for Immediate
     * @uses Immediate::setEntity()
     * @uses Immediate::setUserID()
     * @uses Immediate::setPassword()
     * @uses Immediate::setCustomerNumber()
     * @uses Immediate::setXMLData()
     * @param string $entity
     * @param string $userID
     * @param string $password
     * @param string $customerNumber
     * @param string $xMLData
     */
    public function __construct($entity = null, $userID = null, $password = null, $customerNumber = null, $xMLData = null)
    {
        $this
            ->setEntity($entity)
            ->setUserID($userID)
            ->setPassword($password)
            ->setCustomerNumber($customerNumber)
            ->setXMLData($xMLData);
    }
    /**
     * Get Entity value
     * @return string|null
     */
    public function getEntity()
    {
        return $this->Entity;
    }
    /**
     * Set Entity value
     * @param string $entity
     * @return \StructType\Immediate
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entity, true), gettype($entity)), __LINE__);
        }
        $this->Entity = $entity;
        return $this;
    }
    /**
     * Get UserID value
     * @return string|null
     */
    public function getUserID()
    {
        return $this->UserID;
    }
    /**
     * Set UserID value
     * @param string $userID
     * @return \StructType\Immediate
     */
    public function setUserID($userID = null)
    {
        // validation for constraint: string
        if (!is_null($userID) && !is_string($userID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userID, true), gettype($userID)), __LINE__);
        }
        $this->UserID = $userID;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\Immediate
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\Immediate
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
    /**
     * Get XMLData value
     * @return string|null
     */
    public function getXMLData()
    {
        return $this->XMLData;
    }
    /**
     * Set XMLData value
     * @param string $xMLData
     * @return \StructType\Immediate
     */
    public function setXMLData($xMLData = null)
    {
        // validation for constraint: string
        if (!is_null($xMLData) && !is_string($xMLData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xMLData, true), gettype($xMLData)), __LINE__);
        }
        $this->XMLData = $xMLData;
        return $this;
    }
}
