<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCreditRequest StructType
 * @subpackage Structs
 */
class GetCreditRequest extends AbstractStructBase
{
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The cs
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cs;
    /**
     * Constructor method for GetCreditRequest
     * @uses GetCreditRequest::setUserName()
     * @uses GetCreditRequest::setPassword()
     * @uses GetCreditRequest::setCs()
     * @param string $userName
     * @param string $password
     * @param string $cs
     */
    public function __construct($userName = null, $password = null, $cs = null)
    {
        $this
            ->setUserName($userName)
            ->setPassword($password)
            ->setCs($cs);
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\GetCreditRequest
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\GetCreditRequest
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get cs value
     * @return string|null
     */
    public function getCs()
    {
        return $this->cs;
    }
    /**
     * Set cs value
     * @param string $cs
     * @return \StructType\GetCreditRequest
     */
    public function setCs($cs = null)
    {
        // validation for constraint: string
        if (!is_null($cs) && !is_string($cs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cs, true), gettype($cs)), __LINE__);
        }
        $this->cs = $cs;
        return $this;
    }
}
