<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDealerCMRates StructType
 * @subpackage Structs
 */
class GetDealerCMRates extends AbstractStructBase
{
    /**
     * The dealerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dealerNumber;
    /**
     * The countryNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countryNumber;
    /**
     * Constructor method for GetDealerCMRates
     * @uses GetDealerCMRates::setDealerNumber()
     * @uses GetDealerCMRates::setCountryNumber()
     * @param int $dealerNumber
     * @param int $countryNumber
     */
    public function __construct($dealerNumber = null, $countryNumber = null)
    {
        $this
            ->setDealerNumber($dealerNumber)
            ->setCountryNumber($countryNumber);
    }
    /**
     * Get dealerNumber value
     * @return int
     */
    public function getDealerNumber()
    {
        return $this->dealerNumber;
    }
    /**
     * Set dealerNumber value
     * @param int $dealerNumber
     * @return \StructType\GetDealerCMRates
     */
    public function setDealerNumber($dealerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($dealerNumber) && !(is_int($dealerNumber) || ctype_digit($dealerNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($dealerNumber, true), gettype($dealerNumber)), __LINE__);
        }
        $this->dealerNumber = $dealerNumber;
        return $this;
    }
    /**
     * Get countryNumber value
     * @return int
     */
    public function getCountryNumber()
    {
        return $this->countryNumber;
    }
    /**
     * Set countryNumber value
     * @param int $countryNumber
     * @return \StructType\GetDealerCMRates
     */
    public function setCountryNumber($countryNumber = null)
    {
        // validation for constraint: int
        if (!is_null($countryNumber) && !(is_int($countryNumber) || ctype_digit($countryNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($countryNumber, true), gettype($countryNumber)), __LINE__);
        }
        $this->countryNumber = $countryNumber;
        return $this;
    }
}
