<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DetermineMODAccess StructType
 * @subpackage Structs
 */
class DetermineMODAccess extends AbstractStructBase
{
    /**
     * The ContactNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $ContactNo;
    /**
     * The CustomerNumber
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CustomerNumber;
    /**
     * Constructor method for DetermineMODAccess
     * @uses DetermineMODAccess::setContactNo()
     * @uses DetermineMODAccess::setCustomerNumber()
     * @param int $contactNo
     * @param string $customerNumber
     */
    public function __construct($contactNo = null, $customerNumber = null)
    {
        $this
            ->setContactNo($contactNo)
            ->setCustomerNumber($customerNumber);
    }
    /**
     * Get ContactNo value
     * @return int
     */
    public function getContactNo()
    {
        return $this->ContactNo;
    }
    /**
     * Set ContactNo value
     * @param int $contactNo
     * @return \StructType\DetermineMODAccess
     */
    public function setContactNo($contactNo = null)
    {
        // validation for constraint: int
        if (!is_null($contactNo) && !(is_int($contactNo) || ctype_digit($contactNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contactNo, true), gettype($contactNo)), __LINE__);
        }
        $this->ContactNo = $contactNo;
        return $this;
    }
    /**
     * Get CustomerNumber value
     * @return string|null
     */
    public function getCustomerNumber()
    {
        return $this->CustomerNumber;
    }
    /**
     * Set CustomerNumber value
     * @param string $customerNumber
     * @return \StructType\DetermineMODAccess
     */
    public function setCustomerNumber($customerNumber = null)
    {
        // validation for constraint: string
        if (!is_null($customerNumber) && !is_string($customerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerNumber, true), gettype($customerNumber)), __LINE__);
        }
        $this->CustomerNumber = $customerNumber;
        return $this;
    }
}
