<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @subpackage Services
 */
class Update extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationIDHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApplicationIDHeader $applicationIDHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationIDHeader(\StructType\ApplicationIDHeader $applicationIDHeader, $nameSpace = 'http://schemas.nevatech.com/services/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationIDHeader', $applicationIDHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Update
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationIDHeader
     * - SOAPHeaderNamespaces: http://schemas.nevatech.com/services/
     * - SOAPHeaderTypes: \StructType\ApplicationIDHeader
     * - SOAPHeaders: required
     * - documentation: This method will allow you to update information on an account.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Update $parameters
     * @return \StructType\UpdateResponse|bool
     */
    public function Update(\StructType\Update $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Update($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdateCreditRequest
     * Meta information extracted from the WSDL
     * - documentation: This method will update a pending credit report request for an account (if any).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdateCreditRequest $parameters
     * @return \StructType\UpdateCreditRequestResponse|bool
     */
    public function UpdateCreditRequest(\StructType\UpdateCreditRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdateCreditRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named UpdatePurchaseInfo
     * Meta information extracted from the WSDL
     * - documentation: This method will update the saved purchase info for an account (if any).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UpdatePurchaseInfo $parameters
     * @return \StructType\UpdatePurchaseInfoResponse|bool
     */
    public function UpdatePurchaseInfo(\StructType\UpdatePurchaseInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UpdatePurchaseInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UpdateCreditRequestResponse|\StructType\UpdatePurchaseInfoResponse|\StructType\UpdateResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
