<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetDealerCMRates StructType
 * @subpackage Structs
 */
class GetDealerCMRates extends AbstractStructBase
{
    /**
     * The dealerNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $dealerNumber;
    /**
     * The countryNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $countryNumber;
    /**
     * Constructor method for GetDealerCMRates
     * @uses GetDealerCMRates::setDealerNumber()
     * @uses GetDealerCMRates::setCountryNumber()
     * @param int $dealerNumber
     * @param int $countryNumber
     */
    public function __construct($dealerNumber = null, $countryNumber = null)
    {
        $this
            ->setDealerNumber($dealerNumber)
            ->setCountryNumber($countryNumber);
    }
    /**
     * Get dealerNumber value
     * @return int
     */
    public function getDealerNumber()
    {
        return $this->dealerNumber;
    }
    /**
     * Set dealerNumber value
     * @param int $dealerNumber
     * @return \StructType\GetDealerCMRates
     */
    public function setDealerNumber($dealerNumber = null)
    {
        // validation for constraint: int
        if (!is_null($dealerNumber) && !is_numeric($dealerNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($dealerNumber)), __LINE__);
        }
        $this->dealerNumber = $dealerNumber;
        return $this;
    }
    /**
     * Get countryNumber value
     * @return int
     */
    public function getCountryNumber()
    {
        return $this->countryNumber;
    }
    /**
     * Set countryNumber value
     * @param int $countryNumber
     * @return \StructType\GetDealerCMRates
     */
    public function setCountryNumber($countryNumber = null)
    {
        // validation for constraint: int
        if (!is_null($countryNumber) && !is_numeric($countryNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($countryNumber)), __LINE__);
        }
        $this->countryNumber = $countryNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetDealerCMRates
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
