<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetData $parameters
     * @return \StructType\GetDataResponse|bool
     */
    public function GetData(\StructType\GetData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCreditRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCreditRequest $parameters
     * @return \StructType\GetCreditRequestResponse|bool
     */
    public function GetCreditRequest(\StructType\GetCreditRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetCreditRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPurchaseInfo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPurchaseInfo $parameters
     * @return \StructType\GetPurchaseInfoResponse|bool
     */
    public function GetPurchaseInfo(\StructType\GetPurchaseInfo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetPurchaseInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDealerCMRates
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDealerCMRates $parameters
     * @return \StructType\GetDealerCMRatesResponse|bool
     */
    public function GetDealerCMRates(\StructType\GetDealerCMRates $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetDealerCMRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTimezoneFromZipcode
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTimezoneFromZipcode $parameters
     * @return \StructType\GetTimezoneFromZipcodeResponse|bool
     */
    public function GetTimezoneFromZipcode(\StructType\GetTimezoneFromZipcode $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetTimezoneFromZipcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebServiceVersion
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebServiceVersion $parameters
     * @return \StructType\GetWebServiceVersionResponse|bool
     */
    public function GetWebServiceVersion(\StructType\GetWebServiceVersion $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GetWebServiceVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCreditRequestResponse|\StructType\GetDataResponse|\StructType\GetDealerCMRatesResponse|\StructType\GetPurchaseInfoResponse|\StructType\GetTimezoneFromZipcodeResponse|\StructType\GetWebServiceVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
