<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://senti.monitronics.net/midi/midi.asmx?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://senti.monitronics.net/midi/midi.asmx?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Account ServiceType
 */
$account = new \ServiceType\Account($options);
$account->setSoapHeaderApplicationIDHeader(new \StructType\ApplicationIDHeader());
/**
 * Sample call for AccountOnline operation/method
 */
if ($account->AccountOnline(new \StructType\AccountOnline()) !== false) {
    print_r($account->getResult());
} else {
    print_r($account->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetData operation/method
 */
if ($get->GetData(new \StructType\GetData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetCreditRequest operation/method
 */
if ($get->GetCreditRequest(new \StructType\GetCreditRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetPurchaseInfo operation/method
 */
if ($get->GetPurchaseInfo(new \StructType\GetPurchaseInfo()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetDealerCMRates operation/method
 */
if ($get->GetDealerCMRates(new \StructType\GetDealerCMRates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetTimezoneFromZipcode operation/method
 */
if ($get->GetTimezoneFromZipcode(new \StructType\GetTimezoneFromZipcode()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetWebServiceVersion operation/method
 */
if ($get->GetWebServiceVersion(new \StructType\GetWebServiceVersion()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Immediate ServiceType
 */
$immediate = new \ServiceType\Immediate($options);
$immediate->setSoapHeaderApplicationIDHeader(new \StructType\ApplicationIDHeader());
/**
 * Sample call for Immediate operation/method
 */
if ($immediate->Immediate(new \StructType\Immediate()) !== false) {
    print_r($immediate->getResult());
} else {
    print_r($immediate->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \ServiceType\Update($options);
$update->setSoapHeaderApplicationIDHeader(new \StructType\ApplicationIDHeader());
/**
 * Sample call for Update operation/method
 */
if ($update->Update(new \StructType\Update()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdateCreditRequest operation/method
 */
if ($update->UpdateCreditRequest(new \StructType\UpdateCreditRequest()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for UpdatePurchaseInfo operation/method
 */
if ($update->UpdatePurchaseInfo(new \StructType\UpdatePurchaseInfo()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Partial ServiceType
 */
$partial = new \ServiceType\Partial($options);
$partial->setSoapHeaderApplicationIDHeader(new \StructType\ApplicationIDHeader());
/**
 * Sample call for Partial operation/method
 */
if ($partial->Partial(new \StructType\Partial()) !== false) {
    print_r($partial->getResult());
} else {
    print_r($partial->getLastError());
}
/**
 * Samples for Determine ServiceType
 */
$determine = new \ServiceType\Determine($options);
$determine->setSoapHeaderApplicationIDHeader(new \StructType\ApplicationIDHeader());
/**
 * Sample call for DetermineMODAccess operation/method
 */
if ($determine->DetermineMODAccess(new \StructType\DetermineMODAccess()) !== false) {
    print_r($determine->getResult());
} else {
    print_r($determine->getLastError());
}
