<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Partial StructType
 * @subpackage Structs
 */
class Partial extends AbstractStructBase
{
    /**
     * The wsiBatchNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $wsiBatchNo;
    /**
     * The userName
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $userName;
    /**
     * The password
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The reqType
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $reqType;
    /**
     * The csNo
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $csNo;
    /**
     * Constructor method for Partial
     * @uses Partial::setWsiBatchNo()
     * @uses Partial::setUserName()
     * @uses Partial::setPassword()
     * @uses Partial::setReqType()
     * @uses Partial::setCsNo()
     * @param int $wsiBatchNo
     * @param string $userName
     * @param string $password
     * @param string $reqType
     * @param string $csNo
     */
    public function __construct($wsiBatchNo = null, $userName = null, $password = null, $reqType = null, $csNo = null)
    {
        $this
            ->setWsiBatchNo($wsiBatchNo)
            ->setUserName($userName)
            ->setPassword($password)
            ->setReqType($reqType)
            ->setCsNo($csNo);
    }
    /**
     * Get wsiBatchNo value
     * @return int
     */
    public function getWsiBatchNo()
    {
        return $this->wsiBatchNo;
    }
    /**
     * Set wsiBatchNo value
     * @param int $wsiBatchNo
     * @return \StructType\Partial
     */
    public function setWsiBatchNo($wsiBatchNo = null)
    {
        // validation for constraint: int
        if (!is_null($wsiBatchNo) && !(is_int($wsiBatchNo) || ctype_digit($wsiBatchNo))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($wsiBatchNo, true), gettype($wsiBatchNo)), __LINE__);
        }
        $this->wsiBatchNo = $wsiBatchNo;
        return $this;
    }
    /**
     * Get userName value
     * @return string|null
     */
    public function getUserName()
    {
        return $this->userName;
    }
    /**
     * Set userName value
     * @param string $userName
     * @return \StructType\Partial
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        $this->userName = $userName;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \StructType\Partial
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get reqType value
     * @return string|null
     */
    public function getReqType()
    {
        return $this->reqType;
    }
    /**
     * Set reqType value
     * @param string $reqType
     * @return \StructType\Partial
     */
    public function setReqType($reqType = null)
    {
        // validation for constraint: string
        if (!is_null($reqType) && !is_string($reqType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reqType, true), gettype($reqType)), __LINE__);
        }
        $this->reqType = $reqType;
        return $this;
    }
    /**
     * Get csNo value
     * @return string|null
     */
    public function getCsNo()
    {
        return $this->csNo;
    }
    /**
     * Set csNo value
     * @param string $csNo
     * @return \StructType\Partial
     */
    public function setCsNo($csNo = null)
    {
        // validation for constraint: string
        if (!is_null($csNo) && !is_string($csNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($csNo, true), gettype($csNo)), __LINE__);
        }
        $this->csNo = $csNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Partial
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
