<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ApplicationIDHeader StructType
 * Meta information extracted from the WSDL
 * - type: tns:ApplicationIDHeader
 * @subpackage Structs
 */
class ApplicationIDHeader extends AbstractStructBase
{
    /**
     * The appID
     * Meta information extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $appID;
    /**
     * Constructor method for ApplicationIDHeader
     * @uses ApplicationIDHeader::setAppID()
     * @param string $appID
     */
    public function __construct($appID = null)
    {
        $this
            ->setAppID($appID);
    }
    /**
     * Get appID value
     * @return string|null
     */
    public function getAppID()
    {
        return $this->appID;
    }
    /**
     * Set appID value
     * @param string $appID
     * @return \StructType\ApplicationIDHeader
     */
    public function setAppID($appID = null)
    {
        // validation for constraint: string
        if (!is_null($appID) && !is_string($appID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appID, true), gettype($appID)), __LINE__);
        }
        $this->appID = $appID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ApplicationIDHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
