<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetData
     * Meta information extracted from the WSDL
     * - documentation: This method will allow you to get information about an account or lookup data.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetData $parameters
     * @return \StructType\GetDataResponse|bool
     */
    public function GetData(\StructType\GetData $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetCreditRequest
     * Meta information extracted from the WSDL
     * - documentation: This method will retrieve a pending credit report request for an account (if any).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetCreditRequest $parameters
     * @return \StructType\GetCreditRequestResponse|bool
     */
    public function GetCreditRequest(\StructType\GetCreditRequest $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetCreditRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetPurchaseInfo
     * Meta information extracted from the WSDL
     * - documentation: This method will retrieve the saved purchase info for an account (if any).
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetPurchaseInfo $parameters
     * @return \StructType\GetPurchaseInfoResponse|bool
     */
    public function GetPurchaseInfo(\StructType\GetPurchaseInfo $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetPurchaseInfo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDealerCMRates
     * Meta information extracted from the WSDL
     * - documentation: Internal method for Monitronics use only.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDealerCMRates $parameters
     * @return \StructType\GetDealerCMRatesResponse|bool
     */
    public function GetDealerCMRates(\StructType\GetDealerCMRates $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDealerCMRates($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetTimezoneFromZipcode
     * Meta information extracted from the WSDL
     * - documentation: This method will return the timezone for a given zipcode.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetTimezoneFromZipcode $parameters
     * @return \StructType\GetTimezoneFromZipcodeResponse|bool
     */
    public function GetTimezoneFromZipcode(\StructType\GetTimezoneFromZipcode $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetTimezoneFromZipcode($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetWebServiceVersion
     * Meta information extracted from the WSDL
     * - documentation: This method will return the current version of this web service.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetWebServiceVersion $parameters
     * @return \StructType\GetWebServiceVersionResponse|bool
     */
    public function GetWebServiceVersion(\StructType\GetWebServiceVersion $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetWebServiceVersion($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetCreditRequestResponse|\StructType\GetDataResponse|\StructType\GetDealerCMRatesResponse|\StructType\GetPurchaseInfoResponse|\StructType\GetTimezoneFromZipcodeResponse|\StructType\GetWebServiceVersionResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
