<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Partial ServiceType
 * @subpackage Services
 */
class Partial extends AbstractSoapClientBase
{
    /**
     * Sets the ApplicationIDHeader SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \StructType\ApplicationIDHeader $applicationIDHeader
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderApplicationIDHeader(\StructType\ApplicationIDHeader $applicationIDHeader, $nameSpace = 'http://schemas.nevatech.com/services/', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'ApplicationIDHeader', $applicationIDHeader, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named Partial
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: ApplicationIDHeader
     * - SOAPHeaderNamespaces: http://schemas.nevatech.com/services/
     * - SOAPHeaderTypes: \StructType\ApplicationIDHeader
     * - SOAPHeaders: required
     * - documentation: This method is used to handle partial data saves/gets/deletes.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\Partial $parameters
     * @return \StructType\PartialResponse|bool
     */
    public function Partial(\StructType\Partial $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->Partial($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PartialResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
