<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for list StructType
 * @subpackage Structs
 */
class _list extends AbstractStructBase
{
    /**
     * The ctx
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Context
     */
    public $ctx;
    /**
     * The search_pattern
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $search_pattern;
    /**
     * The auth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $auth;
    /**
     * The include_guests
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $include_guests;
    /**
     * The exclude_users
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $exclude_users;
    /**
     * Constructor method for list
     * @uses _list::setCtx()
     * @uses _list::setSearch_pattern()
     * @uses _list::setAuth()
     * @uses _list::setInclude_guests()
     * @uses _list::setExclude_users()
     * @param \StructType\Context $ctx
     * @param string $search_pattern
     * @param \StructType\Credentials $auth
     * @param bool $include_guests
     * @param bool $exclude_users
     */
    public function __construct(\StructType\Context $ctx = null, $search_pattern = null, \StructType\Credentials $auth = null, $include_guests = null, $exclude_users = null)
    {
        $this
            ->setCtx($ctx)
            ->setSearch_pattern($search_pattern)
            ->setAuth($auth)
            ->setInclude_guests($include_guests)
            ->setExclude_users($exclude_users);
    }
    /**
     * Get ctx value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Context|null
     */
    public function getCtx()
    {
        return isset($this->ctx) ? $this->ctx : null;
    }
    /**
     * Set ctx value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Context $ctx
     * @return \StructType\_list
     */
    public function setCtx(\StructType\Context $ctx = null)
    {
        if (is_null($ctx) || (is_array($ctx) && empty($ctx))) {
            unset($this->ctx);
        } else {
            $this->ctx = $ctx;
        }
        return $this;
    }
    /**
     * Get search_pattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearch_pattern()
    {
        return isset($this->search_pattern) ? $this->search_pattern : null;
    }
    /**
     * Set search_pattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $search_pattern
     * @return \StructType\_list
     */
    public function setSearch_pattern($search_pattern = null)
    {
        // validation for constraint: string
        if (!is_null($search_pattern) && !is_string($search_pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_pattern)), __LINE__);
        }
        if (is_null($search_pattern) || (is_array($search_pattern) && empty($search_pattern))) {
            unset($this->search_pattern);
        } else {
            $this->search_pattern = $search_pattern;
        }
        return $this;
    }
    /**
     * Get auth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getAuth()
    {
        return isset($this->auth) ? $this->auth : null;
    }
    /**
     * Set auth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $auth
     * @return \StructType\_list
     */
    public function setAuth(\StructType\Credentials $auth = null)
    {
        if (is_null($auth) || (is_array($auth) && empty($auth))) {
            unset($this->auth);
        } else {
            $this->auth = $auth;
        }
        return $this;
    }
    /**
     * Get include_guests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getInclude_guests()
    {
        return isset($this->include_guests) ? $this->include_guests : null;
    }
    /**
     * Set include_guests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $include_guests
     * @return \StructType\_list
     */
    public function setInclude_guests($include_guests = null)
    {
        // validation for constraint: boolean
        if (!is_null($include_guests) && !is_bool($include_guests)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($include_guests)), __LINE__);
        }
        if (is_null($include_guests) || (is_array($include_guests) && empty($include_guests))) {
            unset($this->include_guests);
        } else {
            $this->include_guests = $include_guests;
        }
        return $this;
    }
    /**
     * Get exclude_users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExclude_users()
    {
        return isset($this->exclude_users) ? $this->exclude_users : null;
    }
    /**
     * Set exclude_users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exclude_users
     * @return \StructType\_list
     */
    public function setExclude_users($exclude_users = null)
    {
        // validation for constraint: boolean
        if (!is_null($exclude_users) && !is_bool($exclude_users)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exclude_users)), __LINE__);
        }
        if (is_null($exclude_users) || (is_array($exclude_users) && empty($exclude_users))) {
            unset($this->exclude_users);
        } else {
            $this->exclude_users = $exclude_users;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\_list
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
