<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for listCaseInsensitive StructType
 * @subpackage Structs
 */
class ListCaseInsensitive extends AbstractStructBase
{
    /**
     * The ctx
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Context
     */
    public $ctx;
    /**
     * The search_pattern
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $search_pattern;
    /**
     * The auth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $auth;
    /**
     * Constructor method for listCaseInsensitive
     * @uses ListCaseInsensitive::setCtx()
     * @uses ListCaseInsensitive::setSearch_pattern()
     * @uses ListCaseInsensitive::setAuth()
     * @param \StructType\Context $ctx
     * @param string $search_pattern
     * @param \StructType\Credentials $auth
     */
    public function __construct(\StructType\Context $ctx = null, $search_pattern = null, \StructType\Credentials $auth = null)
    {
        $this
            ->setCtx($ctx)
            ->setSearch_pattern($search_pattern)
            ->setAuth($auth);
    }
    /**
     * Get ctx value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Context|null
     */
    public function getCtx()
    {
        return isset($this->ctx) ? $this->ctx : null;
    }
    /**
     * Set ctx value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Context $ctx
     * @return \StructType\ListCaseInsensitive
     */
    public function setCtx(\StructType\Context $ctx = null)
    {
        if (is_null($ctx) || (is_array($ctx) && empty($ctx))) {
            unset($this->ctx);
        } else {
            $this->ctx = $ctx;
        }
        return $this;
    }
    /**
     * Get search_pattern value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSearch_pattern()
    {
        return isset($this->search_pattern) ? $this->search_pattern : null;
    }
    /**
     * Set search_pattern value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $search_pattern
     * @return \StructType\ListCaseInsensitive
     */
    public function setSearch_pattern($search_pattern = null)
    {
        // validation for constraint: string
        if (!is_null($search_pattern) && !is_string($search_pattern)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($search_pattern)), __LINE__);
        }
        if (is_null($search_pattern) || (is_array($search_pattern) && empty($search_pattern))) {
            unset($this->search_pattern);
        } else {
            $this->search_pattern = $search_pattern;
        }
        return $this;
    }
    /**
     * Get auth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getAuth()
    {
        return isset($this->auth) ? $this->auth : null;
    }
    /**
     * Set auth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $auth
     * @return \StructType\ListCaseInsensitive
     */
    public function setAuth(\StructType\Credentials $auth = null)
    {
        if (is_null($auth) || (is_array($auth) && empty($auth))) {
            unset($this->auth);
        } else {
            $this->auth = $auth;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ListCaseInsensitive
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
