<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Move ServiceType
 * @subpackage Services
 */
class Move extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named moveFromUserToContextFilestore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveFromUserToContextFilestore $parameters
     * @return \StructType\MoveFromUserToContextFilestoreResponse|bool
     */
    public function moveFromUserToContextFilestore(\StructType\MoveFromUserToContextFilestore $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->moveFromUserToContextFilestore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveFromMasterToUserFilestore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveFromMasterToUserFilestore $parameters
     * @return \StructType\MoveFromMasterToUserFilestoreResponse|bool
     */
    public function moveFromMasterToUserFilestore(\StructType\MoveFromMasterToUserFilestore $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->moveFromMasterToUserFilestore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveUserFilestore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveUserFilestore $parameters
     * @return \StructType\MoveUserFilestoreResponse|bool
     */
    public function moveUserFilestore(\StructType\MoveUserFilestore $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->moveUserFilestore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveFromContextToUserFilestore
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveFromContextToUserFilestore $parameters
     * @return \StructType\MoveFromContextToUserFilestoreResponse|bool
     */
    public function moveFromContextToUserFilestore(\StructType\MoveFromContextToUserFilestore $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->moveFromContextToUserFilestore($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named moveFromUserFilestoreToMaster
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\MoveFromUserFilestoreToMaster $parameters
     * @return \StructType\MoveFromUserFilestoreToMasterResponse|bool
     */
    public function moveFromUserFilestoreToMaster(\StructType\MoveFromUserFilestoreToMaster $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->moveFromUserFilestoreToMaster($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\MoveFromContextToUserFilestoreResponse|\StructType\MoveFromMasterToUserFilestoreResponse|\StructType\MoveFromUserFilestoreToMasterResponse|\StructType\MoveFromUserToContextFilestoreResponse|\StructType\MoveUserFilestoreResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
