<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetData $parameters
     * @return \StructType\GetDataResponse|bool
     */
    public function getData(\StructType\GetData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getUserCapabilities
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetUserCapabilities $parameters
     * @return \StructType\GetUserCapabilitiesResponse|bool
     */
    public function getUserCapabilities(\StructType\GetUserCapabilities $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getUserCapabilities($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getContextAdmin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetContextAdmin $parameters
     * @return \StructType\GetContextAdminResponse|bool
     */
    public function getContextAdmin(\StructType\GetContextAdmin $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getContextAdmin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getAccessCombinationName
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetAccessCombinationName $parameters
     * @return \StructType\GetAccessCombinationNameResponse|bool
     */
    public function getAccessCombinationName(\StructType\GetAccessCombinationName $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getAccessCombinationName($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getMultipleData
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetMultipleData $parameters
     * @return \StructType\GetMultipleDataResponse|bool
     */
    public function getMultipleData(\StructType\GetMultipleData $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getMultipleData($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getModuleAccess
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetModuleAccess $parameters
     * @return \StructType\GetModuleAccessResponse|bool
     */
    public function getModuleAccess(\StructType\GetModuleAccess $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->getModuleAccess($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetAccessCombinationNameResponse|\StructType\GetContextAdminResponse|\StructType\GetDataResponse|\StructType\GetModuleAccessResponse|\StructType\GetMultipleDataResponse|\StructType\GetUserCapabilitiesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
