<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvalidDataException StructType
 * @subpackage Structs
 */
class InvalidDataException extends Exception
{
    /**
     * The InvalidDataException
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvalidDataException
     */
    public $InvalidDataException;
    /**
     * The objectname
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $objectname;
    /**
     * Constructor method for InvalidDataException
     * @uses InvalidDataException::setInvalidDataException()
     * @uses InvalidDataException::setObjectname()
     * @param \StructType\InvalidDataException $invalidDataException
     * @param string $objectname
     */
    public function __construct(\StructType\InvalidDataException $invalidDataException = null, $objectname = null)
    {
        $this
            ->setInvalidDataException($invalidDataException)
            ->setObjectname($objectname);
    }
    /**
     * Get InvalidDataException value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvalidDataException|null
     */
    public function getInvalidDataException()
    {
        return isset($this->InvalidDataException) ? $this->InvalidDataException : null;
    }
    /**
     * Set InvalidDataException value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\InvalidDataException $invalidDataException
     * @return \StructType\InvalidDataException
     */
    public function setInvalidDataException(\StructType\InvalidDataException $invalidDataException = null)
    {
        if (is_null($invalidDataException) || (is_array($invalidDataException) && empty($invalidDataException))) {
            unset($this->InvalidDataException);
        } else {
            $this->InvalidDataException = $invalidDataException;
        }
        return $this;
    }
    /**
     * Get objectname value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObjectname()
    {
        return isset($this->objectname) ? $this->objectname : null;
    }
    /**
     * Set objectname value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $objectname
     * @return \StructType\InvalidDataException
     */
    public function setObjectname($objectname = null)
    {
        // validation for constraint: string
        if (!is_null($objectname) && !is_string($objectname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($objectname)), __LINE__);
        }
        if (is_null($objectname) || (is_array($objectname) && empty($objectname))) {
            unset($this->objectname);
        } else {
            $this->objectname = $objectname;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvalidDataException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
