<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://oxmail.khalil.pw/webservices/OXUserService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://oxmail.khalil.pw/webservices/OXUserService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getData operation/method
 */
if ($get->getData(new \StructType\GetData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getUserCapabilities operation/method
 */
if ($get->getUserCapabilities(new \StructType\GetUserCapabilities()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getContextAdmin operation/method
 */
if ($get->getContextAdmin(new \StructType\GetContextAdmin()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getAccessCombinationName operation/method
 */
if ($get->getAccessCombinationName(new \StructType\GetAccessCombinationName()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMultipleData operation/method
 */
if ($get->getMultipleData(new \StructType\GetMultipleData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getModuleAccess operation/method
 */
if ($get->getModuleAccess(new \StructType\GetModuleAccess()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for changeModuleAccessGlobal operation/method
 */
if ($change->changeModuleAccessGlobal(new \StructType\ChangeModuleAccessGlobal()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeMailAddressPersonal operation/method
 */
if ($change->changeMailAddressPersonal(new \StructType\ChangeMailAddressPersonal()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeCapabilities operation/method
 */
if ($change->changeCapabilities(new \StructType\ChangeCapabilities()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeByModuleAccessName operation/method
 */
if ($change->changeByModuleAccessName(new \StructType\ChangeByModuleAccessName()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for changeByModuleAccess operation/method
 */
if ($change->changeByModuleAccess(new \StructType\ChangeByModuleAccess()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Sample call for change operation/method
 */
if ($change->change(new \StructType\Change()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for listByAliasDomain operation/method
 */
if ($list->listByAliasDomain(new \StructType\ListByAliasDomain()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listCaseInsensitive operation/method
 */
if ($list->listCaseInsensitive(new \StructType\ListCaseInsensitive()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listAll operation/method
 */
if ($list->listAll(new \StructType\ListAll()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for _list operation/method
 */
if ($list->_list(new \StructType\_list()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for create operation/method
 */
if ($create->create(new \StructType\Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createByModuleAccess operation/method
 */
if ($create->createByModuleAccess(new \StructType\CreateByModuleAccess()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Sample call for createByModuleAccessName operation/method
 */
if ($create->createByModuleAccessName(new \StructType\CreateByModuleAccessName()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \ServiceType\Move($options);
/**
 * Sample call for moveFromUserToContextFilestore operation/method
 */
if ($move->moveFromUserToContextFilestore(new \StructType\MoveFromUserToContextFilestore()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveFromMasterToUserFilestore operation/method
 */
if ($move->moveFromMasterToUserFilestore(new \StructType\MoveFromMasterToUserFilestore()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveUserFilestore operation/method
 */
if ($move->moveUserFilestore(new \StructType\MoveUserFilestore()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveFromContextToUserFilestore operation/method
 */
if ($move->moveFromContextToUserFilestore(new \StructType\MoveFromContextToUserFilestore()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveFromUserFilestoreToMaster operation/method
 */
if ($move->moveFromUserFilestoreToMaster(new \StructType\MoveFromUserFilestoreToMaster()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for delete operation/method
 */
if ($delete->delete(new \StructType\Delete()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteMultiple operation/method
 */
if ($delete->deleteMultiple(new \StructType\DeleteMultiple()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Exists ServiceType
 */
$exists = new \ServiceType\Exists($options);
/**
 * Sample call for exists operation/method
 */
if ($exists->exists(new \StructType\Exists()) !== false) {
    print_r($exists->getResult());
} else {
    print_r($exists->getLastError());
}
