<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for deleteMultiple StructType
 * @subpackage Structs
 */
class DeleteMultiple extends AbstractStructBase
{
    /**
     * The ctx
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Context
     */
    public $ctx;
    /**
     * The users
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\User[]
     */
    public $users;
    /**
     * The auth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $auth;
    /**
     * The reassign
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $reassign;
    /**
     * Constructor method for deleteMultiple
     * @uses DeleteMultiple::setCtx()
     * @uses DeleteMultiple::setUsers()
     * @uses DeleteMultiple::setAuth()
     * @uses DeleteMultiple::setReassign()
     * @param \StructType\Context $ctx
     * @param \StructType\User[] $users
     * @param \StructType\Credentials $auth
     * @param int $reassign
     */
    public function __construct(\StructType\Context $ctx = null, array $users = array(), \StructType\Credentials $auth = null, $reassign = null)
    {
        $this
            ->setCtx($ctx)
            ->setUsers($users)
            ->setAuth($auth)
            ->setReassign($reassign);
    }
    /**
     * Get ctx value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Context|null
     */
    public function getCtx()
    {
        return isset($this->ctx) ? $this->ctx : null;
    }
    /**
     * Set ctx value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Context $ctx
     * @return \StructType\DeleteMultiple
     */
    public function setCtx(\StructType\Context $ctx = null)
    {
        if (is_null($ctx) || (is_array($ctx) && empty($ctx))) {
            unset($this->ctx);
        } else {
            $this->ctx = $ctx;
        }
        return $this;
    }
    /**
     * Get users value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\User[]|null
     */
    public function getUsers()
    {
        return isset($this->users) ? $this->users : null;
    }
    /**
     * Set users value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\User[] $users
     * @return \StructType\DeleteMultiple
     */
    public function setUsers(array $users = array())
    {
        foreach ($users as $deleteMultipleUsersItem) {
            // validation for constraint: itemType
            if (!$deleteMultipleUsersItem instanceof \StructType\User) {
                throw new \InvalidArgumentException(sprintf('The users property can only contain items of \StructType\User, "%s" given', is_object($deleteMultipleUsersItem) ? get_class($deleteMultipleUsersItem) : gettype($deleteMultipleUsersItem)), __LINE__);
            }
        }
        if (is_null($users) || (is_array($users) && empty($users))) {
            unset($this->users);
        } else {
            $this->users = $users;
        }
        return $this;
    }
    /**
     * Add item to users value
     * @throws \InvalidArgumentException
     * @param \StructType\User $item
     * @return \StructType\DeleteMultiple
     */
    public function addToUsers(\StructType\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\User) {
            throw new \InvalidArgumentException(sprintf('The users property can only contain items of \StructType\User, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->users[] = $item;
        return $this;
    }
    /**
     * Get auth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getAuth()
    {
        return isset($this->auth) ? $this->auth : null;
    }
    /**
     * Set auth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $auth
     * @return \StructType\DeleteMultiple
     */
    public function setAuth(\StructType\Credentials $auth = null)
    {
        if (is_null($auth) || (is_array($auth) && empty($auth))) {
            unset($this->auth);
        } else {
            $this->auth = $auth;
        }
        return $this;
    }
    /**
     * Get reassign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReassign()
    {
        return isset($this->reassign) ? $this->reassign : null;
    }
    /**
     * Set reassign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reassign
     * @return \StructType\DeleteMultiple
     */
    public function setReassign($reassign = null)
    {
        // validation for constraint: int
        if (!is_null($reassign) && !is_numeric($reassign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($reassign)), __LINE__);
        }
        if (is_null($reassign) || (is_array($reassign) && empty($reassign))) {
            unset($this->reassign);
        } else {
            $this->reassign = $reassign;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeleteMultiple
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
