<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SOAPStringMapMap StructType
 * @subpackage Structs
 */
class SOAPStringMapMap extends AbstractStructBase
{
    /**
     * The entries
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SOAPMapEntry[]
     */
    public $entries;
    /**
     * Constructor method for SOAPStringMapMap
     * @uses SOAPStringMapMap::setEntries()
     * @param \StructType\SOAPMapEntry[] $entries
     */
    public function __construct(array $entries = array())
    {
        $this
            ->setEntries($entries);
    }
    /**
     * Get entries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SOAPMapEntry[]|null
     */
    public function getEntries()
    {
        return isset($this->entries) ? $this->entries : null;
    }
    /**
     * Set entries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\SOAPMapEntry[] $entries
     * @return \StructType\SOAPStringMapMap
     */
    public function setEntries(array $entries = array())
    {
        foreach ($entries as $sOAPStringMapMapEntriesItem) {
            // validation for constraint: itemType
            if (!$sOAPStringMapMapEntriesItem instanceof \StructType\SOAPMapEntry) {
                throw new \InvalidArgumentException(sprintf('The entries property can only contain items of \StructType\SOAPMapEntry, "%s" given', is_object($sOAPStringMapMapEntriesItem) ? get_class($sOAPStringMapMapEntriesItem) : gettype($sOAPStringMapMapEntriesItem)), __LINE__);
            }
        }
        if (is_null($entries) || (is_array($entries) && empty($entries))) {
            unset($this->entries);
        } else {
            $this->entries = $entries;
        }
        return $this;
    }
    /**
     * Add item to entries value
     * @throws \InvalidArgumentException
     * @param \StructType\SOAPMapEntry $item
     * @return \StructType\SOAPStringMapMap
     */
    public function addToEntries(\StructType\SOAPMapEntry $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SOAPMapEntry) {
            throw new \InvalidArgumentException(sprintf('The entries property can only contain items of \StructType\SOAPMapEntry, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->entries[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SOAPStringMapMap
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
