<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://oxmail.khalil.pw/webservices/OXGroupService?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://oxmail.khalil.pw/webservices/OXGroupService?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for getData operation/method
 */
if ($get->getData(new \StructType\GetData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMembers operation/method
 */
if ($get->getMembers(new \StructType\GetMembers()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getMultipleData operation/method
 */
if ($get->getMultipleData(new \StructType\GetMultipleData()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getDefaultGroup operation/method
 */
if ($get->getDefaultGroup(new \StructType\GetDefaultGroup()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for List ServiceType
 */
$list = new \ServiceType\_List($options);
/**
 * Sample call for listGroupsForUser operation/method
 */
if ($list->listGroupsForUser(new \StructType\ListGroupsForUser()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for listAll operation/method
 */
if ($list->listAll(new \StructType\ListAll()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Sample call for _list operation/method
 */
if ($list->_list(new \StructType\_list()) !== false) {
    print_r($list->getResult());
} else {
    print_r($list->getLastError());
}
/**
 * Samples for Create ServiceType
 */
$create = new \ServiceType\Create($options);
/**
 * Sample call for create operation/method
 */
if ($create->create(new \StructType\Create()) !== false) {
    print_r($create->getResult());
} else {
    print_r($create->getLastError());
}
/**
 * Samples for Remove ServiceType
 */
$remove = new \ServiceType\Remove($options);
/**
 * Sample call for removeMember operation/method
 */
if ($remove->removeMember(new \StructType\RemoveMember()) !== false) {
    print_r($remove->getResult());
} else {
    print_r($remove->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \ServiceType\Delete($options);
/**
 * Sample call for delete operation/method
 */
if ($delete->delete(new \StructType\Delete()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteMultiple operation/method
 */
if ($delete->deleteMultiple(new \StructType\DeleteMultiple()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Change ServiceType
 */
$change = new \ServiceType\Change($options);
/**
 * Sample call for change operation/method
 */
if ($change->change(new \StructType\Change()) !== false) {
    print_r($change->getResult());
} else {
    print_r($change->getLastError());
}
/**
 * Samples for Add ServiceType
 */
$add = new \ServiceType\Add($options);
/**
 * Sample call for addMember operation/method
 */
if ($add->addMember(new \StructType\AddMember()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
