<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getMultipleData StructType
 * @subpackage Structs
 */
class GetMultipleData extends AbstractStructBase
{
    /**
     * The ctx
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Context
     */
    public $ctx;
    /**
     * The grps
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Group[]
     */
    public $grps;
    /**
     * The auth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $auth;
    /**
     * Constructor method for getMultipleData
     * @uses GetMultipleData::setCtx()
     * @uses GetMultipleData::setGrps()
     * @uses GetMultipleData::setAuth()
     * @param \StructType\Context $ctx
     * @param \StructType\Group[] $grps
     * @param \StructType\Credentials $auth
     */
    public function __construct(\StructType\Context $ctx = null, array $grps = array(), \StructType\Credentials $auth = null)
    {
        $this
            ->setCtx($ctx)
            ->setGrps($grps)
            ->setAuth($auth);
    }
    /**
     * Get ctx value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Context|null
     */
    public function getCtx()
    {
        return isset($this->ctx) ? $this->ctx : null;
    }
    /**
     * Set ctx value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Context $ctx
     * @return \StructType\GetMultipleData
     */
    public function setCtx(\StructType\Context $ctx = null)
    {
        if (is_null($ctx) || (is_array($ctx) && empty($ctx))) {
            unset($this->ctx);
        } else {
            $this->ctx = $ctx;
        }
        return $this;
    }
    /**
     * Get grps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Group[]|null
     */
    public function getGrps()
    {
        return isset($this->grps) ? $this->grps : null;
    }
    /**
     * Set grps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Group[] $grps
     * @return \StructType\GetMultipleData
     */
    public function setGrps(array $grps = array())
    {
        foreach ($grps as $getMultipleDataGrpsItem) {
            // validation for constraint: itemType
            if (!$getMultipleDataGrpsItem instanceof \StructType\Group) {
                throw new \InvalidArgumentException(sprintf('The grps property can only contain items of \StructType\Group, "%s" given', is_object($getMultipleDataGrpsItem) ? get_class($getMultipleDataGrpsItem) : gettype($getMultipleDataGrpsItem)), __LINE__);
            }
        }
        if (is_null($grps) || (is_array($grps) && empty($grps))) {
            unset($this->grps);
        } else {
            $this->grps = $grps;
        }
        return $this;
    }
    /**
     * Add item to grps value
     * @throws \InvalidArgumentException
     * @param \StructType\Group $item
     * @return \StructType\GetMultipleData
     */
    public function addToGrps(\StructType\Group $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Group) {
            throw new \InvalidArgumentException(sprintf('The grps property can only contain items of \StructType\Group, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->grps[] = $item;
        return $this;
    }
    /**
     * Get auth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getAuth()
    {
        return isset($this->auth) ? $this->auth : null;
    }
    /**
     * Set auth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $auth
     * @return \StructType\GetMultipleData
     */
    public function setAuth(\StructType\Credentials $auth = null)
    {
        if (is_null($auth) || (is_array($auth) && empty($auth))) {
            unset($this->auth);
        } else {
            $this->auth = $auth;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMultipleData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
