<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for removeMember StructType
 * @subpackage Structs
 */
class RemoveMember extends AbstractStructBase
{
    /**
     * The ctx
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Context
     */
    public $ctx;
    /**
     * The grp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Group
     */
    public $grp;
    /**
     * The members
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\User[]
     */
    public $members;
    /**
     * The auth
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Credentials
     */
    public $auth;
    /**
     * Constructor method for removeMember
     * @uses RemoveMember::setCtx()
     * @uses RemoveMember::setGrp()
     * @uses RemoveMember::setMembers()
     * @uses RemoveMember::setAuth()
     * @param \StructType\Context $ctx
     * @param \StructType\Group $grp
     * @param \StructType\User[] $members
     * @param \StructType\Credentials $auth
     */
    public function __construct(\StructType\Context $ctx = null, \StructType\Group $grp = null, array $members = array(), \StructType\Credentials $auth = null)
    {
        $this
            ->setCtx($ctx)
            ->setGrp($grp)
            ->setMembers($members)
            ->setAuth($auth);
    }
    /**
     * Get ctx value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Context|null
     */
    public function getCtx()
    {
        return isset($this->ctx) ? $this->ctx : null;
    }
    /**
     * Set ctx value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Context $ctx
     * @return \StructType\RemoveMember
     */
    public function setCtx(\StructType\Context $ctx = null)
    {
        if (is_null($ctx) || (is_array($ctx) && empty($ctx))) {
            unset($this->ctx);
        } else {
            $this->ctx = $ctx;
        }
        return $this;
    }
    /**
     * Get grp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Group|null
     */
    public function getGrp()
    {
        return isset($this->grp) ? $this->grp : null;
    }
    /**
     * Set grp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Group $grp
     * @return \StructType\RemoveMember
     */
    public function setGrp(\StructType\Group $grp = null)
    {
        if (is_null($grp) || (is_array($grp) && empty($grp))) {
            unset($this->grp);
        } else {
            $this->grp = $grp;
        }
        return $this;
    }
    /**
     * Get members value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\User[]|null
     */
    public function getMembers()
    {
        return isset($this->members) ? $this->members : null;
    }
    /**
     * Set members value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\User[] $members
     * @return \StructType\RemoveMember
     */
    public function setMembers(array $members = array())
    {
        foreach ($members as $removeMemberMembersItem) {
            // validation for constraint: itemType
            if (!$removeMemberMembersItem instanceof \StructType\User) {
                throw new \InvalidArgumentException(sprintf('The members property can only contain items of \StructType\User, "%s" given', is_object($removeMemberMembersItem) ? get_class($removeMemberMembersItem) : gettype($removeMemberMembersItem)), __LINE__);
            }
        }
        if (is_null($members) || (is_array($members) && empty($members))) {
            unset($this->members);
        } else {
            $this->members = $members;
        }
        return $this;
    }
    /**
     * Add item to members value
     * @throws \InvalidArgumentException
     * @param \StructType\User $item
     * @return \StructType\RemoveMember
     */
    public function addToMembers(\StructType\User $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\User) {
            throw new \InvalidArgumentException(sprintf('The members property can only contain items of \StructType\User, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->members[] = $item;
        return $this;
    }
    /**
     * Get auth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Credentials|null
     */
    public function getAuth()
    {
        return isset($this->auth) ? $this->auth : null;
    }
    /**
     * Set auth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Credentials $auth
     * @return \StructType\RemoveMember
     */
    public function setAuth(\StructType\Credentials $auth = null)
    {
        if (is_null($auth) || (is_array($auth) && empty($auth))) {
            unset($this->auth);
        } else {
            $this->auth = $auth;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\RemoveMember
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
