<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WBBagRS StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WBBagRS
 * @subpackage Structs
 */
class WBBagRS extends AbstractStructBase
{
    /**
     * The BagTagNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BagTagNumber;
    /**
     * The Weight
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Weight;
    /**
     * The WeightUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WeightUnit;
    /**
     * Constructor method for WBBagRS
     * @uses WBBagRS::setBagTagNumber()
     * @uses WBBagRS::setWeight()
     * @uses WBBagRS::setWeightUnit()
     * @param string $bagTagNumber
     * @param float $weight
     * @param string $weightUnit
     */
    public function __construct($bagTagNumber = null, $weight = null, $weightUnit = null)
    {
        $this
            ->setBagTagNumber($bagTagNumber)
            ->setWeight($weight)
            ->setWeightUnit($weightUnit);
    }
    /**
     * Get BagTagNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBagTagNumber()
    {
        return isset($this->BagTagNumber) ? $this->BagTagNumber : null;
    }
    /**
     * Set BagTagNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bagTagNumber
     * @return \StructType\WBBagRS
     */
    public function setBagTagNumber($bagTagNumber = null)
    {
        // validation for constraint: string
        if (!is_null($bagTagNumber) && !is_string($bagTagNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bagTagNumber)), __LINE__);
        }
        if (is_null($bagTagNumber) || (is_array($bagTagNumber) && empty($bagTagNumber))) {
            unset($this->BagTagNumber);
        } else {
            $this->BagTagNumber = $bagTagNumber;
        }
        return $this;
    }
    /**
     * Get Weight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getWeight()
    {
        return isset($this->Weight) ? $this->Weight : null;
    }
    /**
     * Set Weight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $weight
     * @return \StructType\WBBagRS
     */
    public function setWeight($weight = null)
    {
        if (is_null($weight) || (is_array($weight) && empty($weight))) {
            unset($this->Weight);
        } else {
            $this->Weight = $weight;
        }
        return $this;
    }
    /**
     * Get WeightUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWeightUnit()
    {
        return isset($this->WeightUnit) ? $this->WeightUnit : null;
    }
    /**
     * Set WeightUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $weightUnit
     * @return \StructType\WBBagRS
     */
    public function setWeightUnit($weightUnit = null)
    {
        // validation for constraint: string
        if (!is_null($weightUnit) && !is_string($weightUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($weightUnit)), __LINE__);
        }
        if (is_null($weightUnit) || (is_array($weightUnit) && empty($weightUnit))) {
            unset($this->WeightUnit);
        } else {
            $this->WeightUnit = $weightUnit;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WBBagRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
