<?php

namespace EnumType;

/**
 * This class stands for ExceptionTypes EnumType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExceptionTypes
 * @subpackage Enumerations
 */
class ExceptionTypes
{
    /**
     * Constant for value 'BusinessRule'
     * @return string 'BusinessRule'
     */
    const VALUE_BUSINESS_RULE = 'BusinessRule';
    /**
     * Constant for value 'License'
     * @return string 'License'
     */
    const VALUE_LICENSE = 'License';
    /**
     * Constant for value 'Information'
     * @return string 'Information'
     */
    const VALUE_INFORMATION = 'Information';
    /**
     * Constant for value 'Security'
     * @return string 'Security'
     */
    const VALUE_SECURITY = 'Security';
    /**
     * Constant for value 'SystemError'
     * @return string 'SystemError'
     */
    const VALUE_SYSTEM_ERROR = 'SystemError';
    /**
     * Constant for value 'Warning'
     * @return string 'Warning'
     */
    const VALUE_WARNING = 'Warning';
    /**
     * Constant for value 'Validation'
     * @return string 'Validation'
     */
    const VALUE_VALIDATION = 'Validation';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BUSINESS_RULE
     * @uses self::VALUE_LICENSE
     * @uses self::VALUE_INFORMATION
     * @uses self::VALUE_SECURITY
     * @uses self::VALUE_SYSTEM_ERROR
     * @uses self::VALUE_WARNING
     * @uses self::VALUE_VALIDATION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BUSINESS_RULE,
            self::VALUE_LICENSE,
            self::VALUE_INFORMATION,
            self::VALUE_SECURITY,
            self::VALUE_SYSTEM_ERROR,
            self::VALUE_WARNING,
            self::VALUE_VALIDATION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
