<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WBFlightLegRS StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:WBFlightLegRS
 * @subpackage Structs
 */
class WBFlightLegRS extends AbstractStructBase
{
    /**
     * The AircraftType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftType;
    /**
     * The ArrivalAirport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ArrivalAirport;
    /**
     * The BoardDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BoardDate;
    /**
     * The Capacity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Capacity;
    /**
     * The DepartureAirport
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureAirport;
    /**
     * The DepartureDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepartureDate;
    /**
     * The EstimatedArrival
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedArrival;
    /**
     * The EstimatedDeparture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstimatedDeparture;
    /**
     * The FlightStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlightStatus;
    /**
     * The LastModifiedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The LegNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LegNumber;
    /**
     * The MarketingCarrierCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingCarrierCode;
    /**
     * The MarketingFlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MarketingFlightNumber;
    /**
     * The OperatingCarrierCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingCarrierCode;
    /**
     * The OperatingFlightNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperatingFlightNumber;
    /**
     * The ScheduledArrival
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScheduledArrival;
    /**
     * The ScheduledDeparture
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScheduledDeparture;
    /**
     * The TailNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TailNumber;
    /**
     * Constructor method for WBFlightLegRS
     * @uses WBFlightLegRS::setAircraftType()
     * @uses WBFlightLegRS::setArrivalAirport()
     * @uses WBFlightLegRS::setBoardDate()
     * @uses WBFlightLegRS::setCapacity()
     * @uses WBFlightLegRS::setDepartureAirport()
     * @uses WBFlightLegRS::setDepartureDate()
     * @uses WBFlightLegRS::setEstimatedArrival()
     * @uses WBFlightLegRS::setEstimatedDeparture()
     * @uses WBFlightLegRS::setFlightStatus()
     * @uses WBFlightLegRS::setLastModifiedDate()
     * @uses WBFlightLegRS::setLegNumber()
     * @uses WBFlightLegRS::setMarketingCarrierCode()
     * @uses WBFlightLegRS::setMarketingFlightNumber()
     * @uses WBFlightLegRS::setOperatingCarrierCode()
     * @uses WBFlightLegRS::setOperatingFlightNumber()
     * @uses WBFlightLegRS::setScheduledArrival()
     * @uses WBFlightLegRS::setScheduledDeparture()
     * @uses WBFlightLegRS::setTailNumber()
     * @param string $aircraftType
     * @param string $arrivalAirport
     * @param string $boardDate
     * @param int $capacity
     * @param string $departureAirport
     * @param string $departureDate
     * @param string $estimatedArrival
     * @param string $estimatedDeparture
     * @param string $flightStatus
     * @param string $lastModifiedDate
     * @param int $legNumber
     * @param string $marketingCarrierCode
     * @param string $marketingFlightNumber
     * @param string $operatingCarrierCode
     * @param string $operatingFlightNumber
     * @param string $scheduledArrival
     * @param string $scheduledDeparture
     * @param string $tailNumber
     */
    public function __construct($aircraftType = null, $arrivalAirport = null, $boardDate = null, $capacity = null, $departureAirport = null, $departureDate = null, $estimatedArrival = null, $estimatedDeparture = null, $flightStatus = null, $lastModifiedDate = null, $legNumber = null, $marketingCarrierCode = null, $marketingFlightNumber = null, $operatingCarrierCode = null, $operatingFlightNumber = null, $scheduledArrival = null, $scheduledDeparture = null, $tailNumber = null)
    {
        $this
            ->setAircraftType($aircraftType)
            ->setArrivalAirport($arrivalAirport)
            ->setBoardDate($boardDate)
            ->setCapacity($capacity)
            ->setDepartureAirport($departureAirport)
            ->setDepartureDate($departureDate)
            ->setEstimatedArrival($estimatedArrival)
            ->setEstimatedDeparture($estimatedDeparture)
            ->setFlightStatus($flightStatus)
            ->setLastModifiedDate($lastModifiedDate)
            ->setLegNumber($legNumber)
            ->setMarketingCarrierCode($marketingCarrierCode)
            ->setMarketingFlightNumber($marketingFlightNumber)
            ->setOperatingCarrierCode($operatingCarrierCode)
            ->setOperatingFlightNumber($operatingFlightNumber)
            ->setScheduledArrival($scheduledArrival)
            ->setScheduledDeparture($scheduledDeparture)
            ->setTailNumber($tailNumber);
    }
    /**
     * Get AircraftType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftType()
    {
        return isset($this->AircraftType) ? $this->AircraftType : null;
    }
    /**
     * Set AircraftType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftType
     * @return \StructType\WBFlightLegRS
     */
    public function setAircraftType($aircraftType = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftType) && !is_string($aircraftType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aircraftType)), __LINE__);
        }
        if (is_null($aircraftType) || (is_array($aircraftType) && empty($aircraftType))) {
            unset($this->AircraftType);
        } else {
            $this->AircraftType = $aircraftType;
        }
        return $this;
    }
    /**
     * Get ArrivalAirport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArrivalAirport()
    {
        return isset($this->ArrivalAirport) ? $this->ArrivalAirport : null;
    }
    /**
     * Set ArrivalAirport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $arrivalAirport
     * @return \StructType\WBFlightLegRS
     */
    public function setArrivalAirport($arrivalAirport = null)
    {
        // validation for constraint: string
        if (!is_null($arrivalAirport) && !is_string($arrivalAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($arrivalAirport)), __LINE__);
        }
        if (is_null($arrivalAirport) || (is_array($arrivalAirport) && empty($arrivalAirport))) {
            unset($this->ArrivalAirport);
        } else {
            $this->ArrivalAirport = $arrivalAirport;
        }
        return $this;
    }
    /**
     * Get BoardDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBoardDate()
    {
        return isset($this->BoardDate) ? $this->BoardDate : null;
    }
    /**
     * Set BoardDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $boardDate
     * @return \StructType\WBFlightLegRS
     */
    public function setBoardDate($boardDate = null)
    {
        // validation for constraint: string
        if (!is_null($boardDate) && !is_string($boardDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($boardDate)), __LINE__);
        }
        if (is_null($boardDate) || (is_array($boardDate) && empty($boardDate))) {
            unset($this->BoardDate);
        } else {
            $this->BoardDate = $boardDate;
        }
        return $this;
    }
    /**
     * Get Capacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCapacity()
    {
        return isset($this->Capacity) ? $this->Capacity : null;
    }
    /**
     * Set Capacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $capacity
     * @return \StructType\WBFlightLegRS
     */
    public function setCapacity($capacity = null)
    {
        // validation for constraint: int
        if (!is_null($capacity) && !is_numeric($capacity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($capacity)), __LINE__);
        }
        if (is_null($capacity) || (is_array($capacity) && empty($capacity))) {
            unset($this->Capacity);
        } else {
            $this->Capacity = $capacity;
        }
        return $this;
    }
    /**
     * Get DepartureAirport value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureAirport()
    {
        return isset($this->DepartureAirport) ? $this->DepartureAirport : null;
    }
    /**
     * Set DepartureAirport value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureAirport
     * @return \StructType\WBFlightLegRS
     */
    public function setDepartureAirport($departureAirport = null)
    {
        // validation for constraint: string
        if (!is_null($departureAirport) && !is_string($departureAirport)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureAirport)), __LINE__);
        }
        if (is_null($departureAirport) || (is_array($departureAirport) && empty($departureAirport))) {
            unset($this->DepartureAirport);
        } else {
            $this->DepartureAirport = $departureAirport;
        }
        return $this;
    }
    /**
     * Get DepartureDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartureDate()
    {
        return isset($this->DepartureDate) ? $this->DepartureDate : null;
    }
    /**
     * Set DepartureDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departureDate
     * @return \StructType\WBFlightLegRS
     */
    public function setDepartureDate($departureDate = null)
    {
        // validation for constraint: string
        if (!is_null($departureDate) && !is_string($departureDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($departureDate)), __LINE__);
        }
        if (is_null($departureDate) || (is_array($departureDate) && empty($departureDate))) {
            unset($this->DepartureDate);
        } else {
            $this->DepartureDate = $departureDate;
        }
        return $this;
    }
    /**
     * Get EstimatedArrival value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedArrival()
    {
        return isset($this->EstimatedArrival) ? $this->EstimatedArrival : null;
    }
    /**
     * Set EstimatedArrival value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedArrival
     * @return \StructType\WBFlightLegRS
     */
    public function setEstimatedArrival($estimatedArrival = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedArrival) && !is_string($estimatedArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedArrival)), __LINE__);
        }
        if (is_null($estimatedArrival) || (is_array($estimatedArrival) && empty($estimatedArrival))) {
            unset($this->EstimatedArrival);
        } else {
            $this->EstimatedArrival = $estimatedArrival;
        }
        return $this;
    }
    /**
     * Get EstimatedDeparture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstimatedDeparture()
    {
        return isset($this->EstimatedDeparture) ? $this->EstimatedDeparture : null;
    }
    /**
     * Set EstimatedDeparture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estimatedDeparture
     * @return \StructType\WBFlightLegRS
     */
    public function setEstimatedDeparture($estimatedDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedDeparture) && !is_string($estimatedDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estimatedDeparture)), __LINE__);
        }
        if (is_null($estimatedDeparture) || (is_array($estimatedDeparture) && empty($estimatedDeparture))) {
            unset($this->EstimatedDeparture);
        } else {
            $this->EstimatedDeparture = $estimatedDeparture;
        }
        return $this;
    }
    /**
     * Get FlightStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlightStatus()
    {
        return isset($this->FlightStatus) ? $this->FlightStatus : null;
    }
    /**
     * Set FlightStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flightStatus
     * @return \StructType\WBFlightLegRS
     */
    public function setFlightStatus($flightStatus = null)
    {
        // validation for constraint: string
        if (!is_null($flightStatus) && !is_string($flightStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($flightStatus)), __LINE__);
        }
        if (is_null($flightStatus) || (is_array($flightStatus) && empty($flightStatus))) {
            unset($this->FlightStatus);
        } else {
            $this->FlightStatus = $flightStatus;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \StructType\WBFlightLegRS
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get LegNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLegNumber()
    {
        return isset($this->LegNumber) ? $this->LegNumber : null;
    }
    /**
     * Set LegNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $legNumber
     * @return \StructType\WBFlightLegRS
     */
    public function setLegNumber($legNumber = null)
    {
        // validation for constraint: int
        if (!is_null($legNumber) && !is_numeric($legNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($legNumber)), __LINE__);
        }
        if (is_null($legNumber) || (is_array($legNumber) && empty($legNumber))) {
            unset($this->LegNumber);
        } else {
            $this->LegNumber = $legNumber;
        }
        return $this;
    }
    /**
     * Get MarketingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingCarrierCode()
    {
        return isset($this->MarketingCarrierCode) ? $this->MarketingCarrierCode : null;
    }
    /**
     * Set MarketingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingCarrierCode
     * @return \StructType\WBFlightLegRS
     */
    public function setMarketingCarrierCode($marketingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($marketingCarrierCode) && !is_string($marketingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketingCarrierCode)), __LINE__);
        }
        if (is_null($marketingCarrierCode) || (is_array($marketingCarrierCode) && empty($marketingCarrierCode))) {
            unset($this->MarketingCarrierCode);
        } else {
            $this->MarketingCarrierCode = $marketingCarrierCode;
        }
        return $this;
    }
    /**
     * Get MarketingFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarketingFlightNumber()
    {
        return isset($this->MarketingFlightNumber) ? $this->MarketingFlightNumber : null;
    }
    /**
     * Set MarketingFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marketingFlightNumber
     * @return \StructType\WBFlightLegRS
     */
    public function setMarketingFlightNumber($marketingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($marketingFlightNumber) && !is_string($marketingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marketingFlightNumber)), __LINE__);
        }
        if (is_null($marketingFlightNumber) || (is_array($marketingFlightNumber) && empty($marketingFlightNumber))) {
            unset($this->MarketingFlightNumber);
        } else {
            $this->MarketingFlightNumber = $marketingFlightNumber;
        }
        return $this;
    }
    /**
     * Get OperatingCarrierCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingCarrierCode()
    {
        return isset($this->OperatingCarrierCode) ? $this->OperatingCarrierCode : null;
    }
    /**
     * Set OperatingCarrierCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingCarrierCode
     * @return \StructType\WBFlightLegRS
     */
    public function setOperatingCarrierCode($operatingCarrierCode = null)
    {
        // validation for constraint: string
        if (!is_null($operatingCarrierCode) && !is_string($operatingCarrierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatingCarrierCode)), __LINE__);
        }
        if (is_null($operatingCarrierCode) || (is_array($operatingCarrierCode) && empty($operatingCarrierCode))) {
            unset($this->OperatingCarrierCode);
        } else {
            $this->OperatingCarrierCode = $operatingCarrierCode;
        }
        return $this;
    }
    /**
     * Get OperatingFlightNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperatingFlightNumber()
    {
        return isset($this->OperatingFlightNumber) ? $this->OperatingFlightNumber : null;
    }
    /**
     * Set OperatingFlightNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operatingFlightNumber
     * @return \StructType\WBFlightLegRS
     */
    public function setOperatingFlightNumber($operatingFlightNumber = null)
    {
        // validation for constraint: string
        if (!is_null($operatingFlightNumber) && !is_string($operatingFlightNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatingFlightNumber)), __LINE__);
        }
        if (is_null($operatingFlightNumber) || (is_array($operatingFlightNumber) && empty($operatingFlightNumber))) {
            unset($this->OperatingFlightNumber);
        } else {
            $this->OperatingFlightNumber = $operatingFlightNumber;
        }
        return $this;
    }
    /**
     * Get ScheduledArrival value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScheduledArrival()
    {
        return isset($this->ScheduledArrival) ? $this->ScheduledArrival : null;
    }
    /**
     * Set ScheduledArrival value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scheduledArrival
     * @return \StructType\WBFlightLegRS
     */
    public function setScheduledArrival($scheduledArrival = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledArrival) && !is_string($scheduledArrival)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledArrival)), __LINE__);
        }
        if (is_null($scheduledArrival) || (is_array($scheduledArrival) && empty($scheduledArrival))) {
            unset($this->ScheduledArrival);
        } else {
            $this->ScheduledArrival = $scheduledArrival;
        }
        return $this;
    }
    /**
     * Get ScheduledDeparture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScheduledDeparture()
    {
        return isset($this->ScheduledDeparture) ? $this->ScheduledDeparture : null;
    }
    /**
     * Set ScheduledDeparture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scheduledDeparture
     * @return \StructType\WBFlightLegRS
     */
    public function setScheduledDeparture($scheduledDeparture = null)
    {
        // validation for constraint: string
        if (!is_null($scheduledDeparture) && !is_string($scheduledDeparture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($scheduledDeparture)), __LINE__);
        }
        if (is_null($scheduledDeparture) || (is_array($scheduledDeparture) && empty($scheduledDeparture))) {
            unset($this->ScheduledDeparture);
        } else {
            $this->ScheduledDeparture = $scheduledDeparture;
        }
        return $this;
    }
    /**
     * Get TailNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTailNumber()
    {
        return isset($this->TailNumber) ? $this->TailNumber : null;
    }
    /**
     * Set TailNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tailNumber
     * @return \StructType\WBFlightLegRS
     */
    public function setTailNumber($tailNumber = null)
    {
        // validation for constraint: string
        if (!is_null($tailNumber) && !is_string($tailNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tailNumber)), __LINE__);
        }
        if (is_null($tailNumber) || (is_array($tailNumber) && empty($tailNumber))) {
            unset($this->TailNumber);
        } else {
            $this->TailNumber = $tailNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WBFlightLegRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
