<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfException ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfException
 * @subpackage Arrays
 */
class ArrayOfException extends AbstractStructArrayBase
{
    /**
     * The Exception
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Exception[]
     */
    public $Exception;
    /**
     * Constructor method for ArrayOfException
     * @uses ArrayOfException::setException()
     * @param \StructType\Exception[] $exception
     */
    public function __construct(array $exception = array())
    {
        $this
            ->setException($exception);
    }
    /**
     * Get Exception value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Exception[]|null
     */
    public function getException()
    {
        return isset($this->Exception) ? $this->Exception : null;
    }
    /**
     * Set Exception value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Exception[] $exception
     * @return \ArrayType\ArrayOfException
     */
    public function setException(array $exception = array())
    {
        foreach ($exception as $arrayOfExceptionExceptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfExceptionExceptionItem instanceof \StructType\Exception) {
                throw new \InvalidArgumentException(sprintf('The Exception property can only contain items of \StructType\Exception, "%s" given', is_object($arrayOfExceptionExceptionItem) ? get_class($arrayOfExceptionExceptionItem) : gettype($arrayOfExceptionExceptionItem)), __LINE__);
            }
        }
        if (is_null($exception) || (is_array($exception) && empty($exception))) {
            unset($this->Exception);
        } else {
            $this->Exception = $exception;
        }
        return $this;
    }
    /**
     * Add item to Exception value
     * @throws \InvalidArgumentException
     * @param \StructType\Exception $item
     * @return \ArrayType\ArrayOfException
     */
    public function addToException(\StructType\Exception $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Exception) {
            throw new \InvalidArgumentException(sprintf('The Exception property can only contain items of \StructType\Exception, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Exception[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Exception|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Exception|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Exception|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Exception|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Exception|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Exception
     */
    public function getAttributeName()
    {
        return 'Exception';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfException
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
