<?php

namespace axa.ma\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resultLead StructType
 * @subpackage Structs
 */
class ResultLead extends AbstractStructBase
{
    /**
     * The codeResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codeResult;
    /**
     * The erreurs
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $erreurs;
    /**
     * The idLead
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $idLead;
    /**
     * Constructor method for resultLead
     * @uses ResultLead::setCodeResult()
     * @uses ResultLead::setErreurs()
     * @uses ResultLead::setIdLead()
     * @param string $codeResult
     * @param string[] $erreurs
     * @param string $idLead
     */
    public function __construct($codeResult = null, array $erreurs = array(), $idLead = null)
    {
        $this
            ->setCodeResult($codeResult)
            ->setErreurs($erreurs)
            ->setIdLead($idLead);
    }
    /**
     * Get codeResult value
     * @return string|null
     */
    public function getCodeResult()
    {
        return $this->codeResult;
    }
    /**
     * Set codeResult value
     * @param string $codeResult
     * @return \axa.ma\StructType\ResultLead
     */
    public function setCodeResult($codeResult = null)
    {
        // validation for constraint: string
        if (!is_null($codeResult) && !is_string($codeResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codeResult)), __LINE__);
        }
        $this->codeResult = $codeResult;
        return $this;
    }
    /**
     * Get erreurs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getErreurs()
    {
        return isset($this->erreurs) ? $this->erreurs : null;
    }
    /**
     * Set erreurs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $erreurs
     * @return \axa.ma\StructType\ResultLead
     */
    public function setErreurs(array $erreurs = array())
    {
        foreach ($erreurs as $resultLeadErreursItem) {
            // validation for constraint: itemType
            if (!is_string($resultLeadErreursItem)) {
                throw new \InvalidArgumentException(sprintf('The erreurs property can only contain items of string, "%s" given', is_object($resultLeadErreursItem) ? get_class($resultLeadErreursItem) : gettype($resultLeadErreursItem)), __LINE__);
            }
        }
        if (is_null($erreurs) || (is_array($erreurs) && empty($erreurs))) {
            unset($this->erreurs);
        } else {
            $this->erreurs = $erreurs;
        }
        return $this;
    }
    /**
     * Add item to erreurs value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \axa.ma\StructType\ResultLead
     */
    public function addToErreurs($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The erreurs property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->erreurs[] = $item;
        return $this;
    }
    /**
     * Get idLead value
     * @return string|null
     */
    public function getIdLead()
    {
        return $this->idLead;
    }
    /**
     * Set idLead value
     * @param string $idLead
     * @return \axa.ma\StructType\ResultLead
     */
    public function setIdLead($idLead = null)
    {
        // validation for constraint: string
        if (!is_null($idLead) && !is_string($idLead)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLead)), __LINE__);
        }
        $this->idLead = $idLead;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \axa.ma\StructType\ResultLead
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
