<?php

namespace axa.ma\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for COULEAD ServiceType
 * @subpackage Services
 */
class COULEAD extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named COULEAD
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \axa.ma\StructType\COULEAD $parameters
     * @return \axa.ma\StructType\COULEADResponse|bool
     */
    public function COULEAD(\axa.ma\StructType\COULEAD $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->COULEAD($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \axa.ma\StructType\COULEADResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
