<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fieldsType StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceFieldsType extends AbstractStructBase
{
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KanbanCardService\StructType\KanbanCardServiceFieldType[]
     */
    public $field;
    /**
     * Constructor method for fieldsType
     * @uses KanbanCardServiceFieldsType::setField()
     * @param \KanbanCardService\StructType\KanbanCardServiceFieldType[] $field
     */
    public function __construct(array $field = array())
    {
        $this
            ->setField($field);
    }
    /**
     * Get field value
     * @return \KanbanCardService\StructType\KanbanCardServiceFieldType[]|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @throws \InvalidArgumentException
     * @param \KanbanCardService\StructType\KanbanCardServiceFieldType[] $field
     * @return \KanbanCardService\StructType\KanbanCardServiceFieldsType
     */
    public function setField(array $field = array())
    {
        foreach ($field as $fieldsTypeFieldItem) {
            // validation for constraint: itemType
            if (!$fieldsTypeFieldItem instanceof \KanbanCardService\StructType\KanbanCardServiceFieldType) {
                throw new \InvalidArgumentException(sprintf('The field property can only contain items of \KanbanCardService\StructType\KanbanCardServiceFieldType, "%s" given', is_object($fieldsTypeFieldItem) ? get_class($fieldsTypeFieldItem) : gettype($fieldsTypeFieldItem)), __LINE__);
            }
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Add item to field value
     * @throws \InvalidArgumentException
     * @param \KanbanCardService\StructType\KanbanCardServiceFieldType $item
     * @return \KanbanCardService\StructType\KanbanCardServiceFieldsType
     */
    public function addToField(\KanbanCardService\StructType\KanbanCardServiceFieldType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KanbanCardService\StructType\KanbanCardServiceFieldType) {
            throw new \InvalidArgumentException(sprintf('The field property can only contain items of \KanbanCardService\StructType\KanbanCardServiceFieldType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->field[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceFieldsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
