<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for fields StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceFields extends AbstractStructBase
{
    /**
     * The field
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \KanbanCardService\StructType\KanbanCardServiceField[]
     */
    public $field;
    /**
     * Constructor method for fields
     * @uses KanbanCardServiceFields::setField()
     * @param \KanbanCardService\StructType\KanbanCardServiceField[] $field
     */
    public function __construct(array $field = array())
    {
        $this
            ->setField($field);
    }
    /**
     * Get field value
     * @return \KanbanCardService\StructType\KanbanCardServiceField[]|null
     */
    public function getField()
    {
        return $this->field;
    }
    /**
     * Set field value
     * @throws \InvalidArgumentException
     * @param \KanbanCardService\StructType\KanbanCardServiceField[] $field
     * @return \KanbanCardService\StructType\KanbanCardServiceFields
     */
    public function setField(array $field = array())
    {
        foreach ($field as $fieldsFieldItem) {
            // validation for constraint: itemType
            if (!$fieldsFieldItem instanceof \KanbanCardService\StructType\KanbanCardServiceField) {
                throw new \InvalidArgumentException(sprintf('The field property can only contain items of \KanbanCardService\StructType\KanbanCardServiceField, "%s" given', is_object($fieldsFieldItem) ? get_class($fieldsFieldItem) : gettype($fieldsFieldItem)), __LINE__);
            }
        }
        $this->field = $field;
        return $this;
    }
    /**
     * Add item to field value
     * @throws \InvalidArgumentException
     * @param \KanbanCardService\StructType\KanbanCardServiceField $item
     * @return \KanbanCardService\StructType\KanbanCardServiceFields
     */
    public function addToField(\KanbanCardService\StructType\KanbanCardServiceField $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KanbanCardService\StructType\KanbanCardServiceField) {
            throw new \InvalidArgumentException(sprintf('The field property can only contain items of \KanbanCardService\StructType\KanbanCardServiceField, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->field[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceFields
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
