<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for card StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceCard extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The mode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mode;
    /**
     * The fields
     * @var \KanbanCardService\StructType\KanbanCardServiceFields
     */
    public $fields;
    /**
     * The cardUniqueId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardUniqueId;
    /**
     * The fromQkeyId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $fromQkeyId;
    /**
     * The toQkeyId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $toQkeyId;
    /**
     * The fromSwimId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $fromSwimId;
    /**
     * The toSwimId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $toSwimId;
    /**
     * The queueId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $queueId;
    /**
     * The swimId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $swimId;
    /**
     * Constructor method for card
     * @uses KanbanCardServiceCard::setProjectId()
     * @uses KanbanCardServiceCard::setCardType()
     * @uses KanbanCardServiceCard::setMode()
     * @uses KanbanCardServiceCard::setFields()
     * @uses KanbanCardServiceCard::setCardUniqueId()
     * @uses KanbanCardServiceCard::setFromQkeyId()
     * @uses KanbanCardServiceCard::setToQkeyId()
     * @uses KanbanCardServiceCard::setFromSwimId()
     * @uses KanbanCardServiceCard::setToSwimId()
     * @uses KanbanCardServiceCard::setQueueId()
     * @uses KanbanCardServiceCard::setSwimId()
     * @param string $projectId
     * @param string $cardType
     * @param string $mode
     * @param \KanbanCardService\StructType\KanbanCardServiceFields $fields
     * @param string $cardUniqueId
     * @param string $fromQkeyId
     * @param string $toQkeyId
     * @param string $fromSwimId
     * @param string $toSwimId
     * @param string $queueId
     * @param string $swimId
     */
    public function __construct($projectId = null, $cardType = null, $mode = null, \KanbanCardService\StructType\KanbanCardServiceFields $fields = null, $cardUniqueId = null, $fromQkeyId = null, $toQkeyId = null, $fromSwimId = null, $toSwimId = null, $queueId = null, $swimId = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setMode($mode)
            ->setFields($fields)
            ->setCardUniqueId($cardUniqueId)
            ->setFromQkeyId($fromQkeyId)
            ->setToQkeyId($toQkeyId)
            ->setFromSwimId($fromSwimId)
            ->setToSwimId($toSwimId)
            ->setQueueId($queueId)
            ->setSwimId($swimId);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @param string $mode
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mode)), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get fields value
     * @return \KanbanCardService\StructType\KanbanCardServiceFields|null
     */
    public function getFields()
    {
        return $this->fields;
    }
    /**
     * Set fields value
     * @param \KanbanCardService\StructType\KanbanCardServiceFields $fields
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setFields(\KanbanCardService\StructType\KanbanCardServiceFields $fields = null)
    {
        $this->fields = $fields;
        return $this;
    }
    /**
     * Get cardUniqueId value
     * @return string|null
     */
    public function getCardUniqueId()
    {
        return $this->cardUniqueId;
    }
    /**
     * Set cardUniqueId value
     * @param string $cardUniqueId
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setCardUniqueId($cardUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($cardUniqueId) && !is_string($cardUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardUniqueId)), __LINE__);
        }
        $this->cardUniqueId = $cardUniqueId;
        return $this;
    }
    /**
     * Get fromQkeyId value
     * @return string|null
     */
    public function getFromQkeyId()
    {
        return $this->fromQkeyId;
    }
    /**
     * Set fromQkeyId value
     * @param string $fromQkeyId
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setFromQkeyId($fromQkeyId = null)
    {
        // validation for constraint: string
        if (!is_null($fromQkeyId) && !is_string($fromQkeyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromQkeyId)), __LINE__);
        }
        $this->fromQkeyId = $fromQkeyId;
        return $this;
    }
    /**
     * Get toQkeyId value
     * @return string|null
     */
    public function getToQkeyId()
    {
        return $this->toQkeyId;
    }
    /**
     * Set toQkeyId value
     * @param string $toQkeyId
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setToQkeyId($toQkeyId = null)
    {
        // validation for constraint: string
        if (!is_null($toQkeyId) && !is_string($toQkeyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toQkeyId)), __LINE__);
        }
        $this->toQkeyId = $toQkeyId;
        return $this;
    }
    /**
     * Get fromSwimId value
     * @return string|null
     */
    public function getFromSwimId()
    {
        return $this->fromSwimId;
    }
    /**
     * Set fromSwimId value
     * @param string $fromSwimId
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setFromSwimId($fromSwimId = null)
    {
        // validation for constraint: string
        if (!is_null($fromSwimId) && !is_string($fromSwimId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromSwimId)), __LINE__);
        }
        $this->fromSwimId = $fromSwimId;
        return $this;
    }
    /**
     * Get toSwimId value
     * @return string|null
     */
    public function getToSwimId()
    {
        return $this->toSwimId;
    }
    /**
     * Set toSwimId value
     * @param string $toSwimId
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setToSwimId($toSwimId = null)
    {
        // validation for constraint: string
        if (!is_null($toSwimId) && !is_string($toSwimId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toSwimId)), __LINE__);
        }
        $this->toSwimId = $toSwimId;
        return $this;
    }
    /**
     * Get queueId value
     * @return string|null
     */
    public function getQueueId()
    {
        return $this->queueId;
    }
    /**
     * Set queueId value
     * @param string $queueId
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setQueueId($queueId = null)
    {
        // validation for constraint: string
        if (!is_null($queueId) && !is_string($queueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($queueId)), __LINE__);
        }
        $this->queueId = $queueId;
        return $this;
    }
    /**
     * Get swimId value
     * @return string|null
     */
    public function getSwimId()
    {
        return $this->swimId;
    }
    /**
     * Set swimId value
     * @param string $swimId
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public function setSwimId($swimId = null)
    {
        // validation for constraint: string
        if (!is_null($swimId) && !is_string($swimId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($swimId)), __LINE__);
        }
        $this->swimId = $swimId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceCard
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
