<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Update ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceUpdate extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named updateCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceUpdateCardDetails $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceUpdateCardResponse|bool
     */
    public function updateCard(\KanbanCardService\StructType\KanbanCardServiceUpdateCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->updateCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named updateMultipleCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceUpdateMultipleCardInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceUpdateMultipleCardResponse|bool
     */
    public function updateMultipleCard(\KanbanCardService\StructType\KanbanCardServiceUpdateMultipleCardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->updateMultipleCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceUpdateCardResponse|\KanbanCardService\StructType\KanbanCardServiceUpdateMultipleCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
