<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceGet extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named getCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceGetCardRequest $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardResponse|bool
     */
    public function getCard(\KanbanCardService\StructType\KanbanCardServiceGetCardRequest $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCardsModifiedSincedate
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceGetCardsModifiedSincedateInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardsModifiedSincedateResponse|bool
     */
    public function getCardsModifiedSincedate(\KanbanCardService\StructType\KanbanCardServiceGetCardsModifiedSincedateInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCardsModifiedSincedate($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCardDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsResponse|bool
     */
    public function getCardDetails(\KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCardDetails($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getCardsByFilter
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterResponse|bool
     */
    public function getCardsByFilter(\KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getCardsByFilter($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getSmartLaneDetails
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceGetSmartLaneDetailsInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceGetSmartLaneDetailsResponse|bool
     */
    public function getSmartLaneDetails(\KanbanCardService\StructType\KanbanCardServiceGetSmartLaneDetailsInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getSmartLaneDetails($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named getBoardCards
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceGetBoardCardsRequest $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceGetBoardCardsResponse|bool
     */
    public function getBoardCards(\KanbanCardService\StructType\KanbanCardServiceGetBoardCardsRequest $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->getBoardCards($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceGetBoardCardsResponse|\KanbanCardService\StructType\KanbanCardServiceGetCardDetailsResponse|\KanbanCardService\StructType\KanbanCardServiceGetCardResponse|\KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterResponse|\KanbanCardService\StructType\KanbanCardServiceGetCardsModifiedSincedateResponse|\KanbanCardService\StructType\KanbanCardServiceGetSmartLaneDetailsResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
