<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Archive ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceArchive extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named archiveCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceArchiveCardDetails $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceArchiveCardResponse|bool
     */
    public function archiveCard(\KanbanCardService\StructType\KanbanCardServiceArchiveCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->archiveCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named archiveMultipleCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceArchiveMultipleCardInput $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceArchiveMultipleCardResponse|bool
     */
    public function archiveMultipleCard(\KanbanCardService\StructType\KanbanCardServiceArchiveMultipleCardInput $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->archiveMultipleCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceArchiveCardResponse|\KanbanCardService\StructType\KanbanCardServiceArchiveMultipleCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
