<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://soft2u.ro/tools/wsdl/KanbanCardService.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://soft2u.ro/tools/wsdl/KanbanCardService.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => \KanbanCardService\KanbanCardServiceClassMap::get(),
);
/**
 * Samples for Add ServiceType
 */
$add = new \KanbanCardService\ServiceType\KanbanCardServiceAdd($options);
/**
 * Sample call for addCard operation/method
 */
if ($add->addCard(new \KanbanCardService\StructType\KanbanCardServiceAddCardDetails()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Sample call for addMultipleCard operation/method
 */
if ($add->addMultipleCard(new \KanbanCardService\StructType\KanbanCardServiceAddMultipleCardInput()) !== false) {
    print_r($add->getResult());
} else {
    print_r($add->getLastError());
}
/**
 * Samples for Update ServiceType
 */
$update = new \KanbanCardService\ServiceType\KanbanCardServiceUpdate($options);
/**
 * Sample call for updateCard operation/method
 */
if ($update->updateCard(new \KanbanCardService\StructType\KanbanCardServiceUpdateCardDetails()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Sample call for updateMultipleCard operation/method
 */
if ($update->updateMultipleCard(new \KanbanCardService\StructType\KanbanCardServiceUpdateMultipleCardInput()) !== false) {
    print_r($update->getResult());
} else {
    print_r($update->getLastError());
}
/**
 * Samples for Archive ServiceType
 */
$archive = new \KanbanCardService\ServiceType\KanbanCardServiceArchive($options);
/**
 * Sample call for archiveCard operation/method
 */
if ($archive->archiveCard(new \KanbanCardService\StructType\KanbanCardServiceArchiveCardDetails()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Sample call for archiveMultipleCard operation/method
 */
if ($archive->archiveMultipleCard(new \KanbanCardService\StructType\KanbanCardServiceArchiveMultipleCardInput()) !== false) {
    print_r($archive->getResult());
} else {
    print_r($archive->getLastError());
}
/**
 * Samples for Block ServiceType
 */
$block = new \KanbanCardService\ServiceType\KanbanCardServiceBlock($options);
/**
 * Sample call for blockCard operation/method
 */
if ($block->blockCard(new \KanbanCardService\StructType\KanbanCardServiceBlockCardDetails()) !== false) {
    print_r($block->getResult());
} else {
    print_r($block->getLastError());
}
/**
 * Samples for Get ServiceType
 */
$get = new \KanbanCardService\ServiceType\KanbanCardServiceGet($options);
/**
 * Sample call for getCard operation/method
 */
if ($get->getCard(new \KanbanCardService\StructType\KanbanCardServiceGetCardRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCardsModifiedSincedate operation/method
 */
if ($get->getCardsModifiedSincedate(new \KanbanCardService\StructType\KanbanCardServiceGetCardsModifiedSincedateInput()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCardDetails operation/method
 */
if ($get->getCardDetails(new \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getCardsByFilter operation/method
 */
if ($get->getCardsByFilter(new \KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterInput()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getSmartLaneDetails operation/method
 */
if ($get->getSmartLaneDetails(new \KanbanCardService\StructType\KanbanCardServiceGetSmartLaneDetailsInput()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for getBoardCards operation/method
 */
if ($get->getBoardCards(new \KanbanCardService\StructType\KanbanCardServiceGetBoardCardsRequest()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Samples for Move ServiceType
 */
$move = new \KanbanCardService\ServiceType\KanbanCardServiceMove($options);
/**
 * Sample call for moveCardToBacklog operation/method
 */
if ($move->moveCardToBacklog(new \KanbanCardService\StructType\KanbanCardServiceMoveCardToBacklogDetails()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveMultipleCardToBacklog operation/method
 */
if ($move->moveMultipleCardToBacklog(new \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToBacklogInput()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveCardOnBoard operation/method
 */
if ($move->moveCardOnBoard(new \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveMultipleCardOnBoard operation/method
 */
if ($move->moveMultipleCardOnBoard(new \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardInput()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveCardtoReady operation/method
 */
if ($move->moveCardtoReady(new \KanbanCardService\StructType\KanbanCardServiceMoveCardtoReadyDetails()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Sample call for moveMultipleCardToReady operation/method
 */
if ($move->moveMultipleCardToReady(new \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardToReadyInput()) !== false) {
    print_r($move->getResult());
} else {
    print_r($move->getLastError());
}
/**
 * Samples for Unblock ServiceType
 */
$unblock = new \KanbanCardService\ServiceType\KanbanCardServiceUnblock($options);
/**
 * Sample call for unblockCard operation/method
 */
if ($unblock->unblockCard(new \KanbanCardService\StructType\KanbanCardServiceUnblockCardDetails()) !== false) {
    print_r($unblock->getResult());
} else {
    print_r($unblock->getLastError());
}
/**
 * Samples for Delete ServiceType
 */
$delete = new \KanbanCardService\ServiceType\KanbanCardServiceDelete($options);
/**
 * Sample call for deleteCard operation/method
 */
if ($delete->deleteCard(new \KanbanCardService\StructType\KanbanCardServiceDeleteCardInput()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Sample call for deleteMultipleCard operation/method
 */
if ($delete->deleteMultipleCard(new \KanbanCardService\StructType\KanbanCardServiceDeleteMultipleCardInput()) !== false) {
    print_r($delete->getResult());
} else {
    print_r($delete->getLastError());
}
/**
 * Samples for Transfer ServiceType
 */
$transfer = new \KanbanCardService\ServiceType\KanbanCardServiceTransfer($options);
/**
 * Sample call for transferCard operation/method
 */
if ($transfer->transferCard(new \KanbanCardService\StructType\KanbanCardServiceTransferCardInput()) !== false) {
    print_r($transfer->getResult());
} else {
    print_r($transfer->getLastError());
}
/**
 * Samples for Convert ServiceType
 */
$convert = new \KanbanCardService\ServiceType\KanbanCardServiceConvert($options);
/**
 * Sample call for convertCard operation/method
 */
if ($convert->convertCard(new \KanbanCardService\StructType\KanbanCardServiceConvertCardInput()) !== false) {
    print_r($convert->getResult());
} else {
    print_r($convert->getLastError());
}
