<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for transferCardInput StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceTransferCardInput extends AbstractStructBase
{
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * The cardUniqueId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardUniqueId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $projectId;
    /**
     * The destinationProjectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $destinationProjectId;
    /**
     * The destinationSwimId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $destinationSwimId;
    /**
     * The destinationQueueId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var int
     */
    public $destinationQueueId;
    /**
     * Constructor method for transferCardInput
     * @uses KanbanCardServiceTransferCardInput::setUserLoginId()
     * @uses KanbanCardServiceTransferCardInput::setCardUniqueId()
     * @uses KanbanCardServiceTransferCardInput::setCardType()
     * @uses KanbanCardServiceTransferCardInput::setProjectId()
     * @uses KanbanCardServiceTransferCardInput::setDestinationProjectId()
     * @uses KanbanCardServiceTransferCardInput::setDestinationSwimId()
     * @uses KanbanCardServiceTransferCardInput::setDestinationQueueId()
     * @param string $userLoginId
     * @param string $cardUniqueId
     * @param string $cardType
     * @param int $projectId
     * @param int $destinationProjectId
     * @param int $destinationSwimId
     * @param int $destinationQueueId
     */
    public function __construct($userLoginId = null, $cardUniqueId = null, $cardType = null, $projectId = null, $destinationProjectId = null, $destinationSwimId = null, $destinationQueueId = null)
    {
        $this
            ->setUserLoginId($userLoginId)
            ->setCardUniqueId($cardUniqueId)
            ->setCardType($cardType)
            ->setProjectId($projectId)
            ->setDestinationProjectId($destinationProjectId)
            ->setDestinationSwimId($destinationSwimId)
            ->setDestinationQueueId($destinationQueueId);
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \KanbanCardService\StructType\KanbanCardServiceTransferCardInput
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Get cardUniqueId value
     * @return string|null
     */
    public function getCardUniqueId()
    {
        return $this->cardUniqueId;
    }
    /**
     * Set cardUniqueId value
     * @param string $cardUniqueId
     * @return \KanbanCardService\StructType\KanbanCardServiceTransferCardInput
     */
    public function setCardUniqueId($cardUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($cardUniqueId) && !is_string($cardUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardUniqueId)), __LINE__);
        }
        $this->cardUniqueId = $cardUniqueId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \KanbanCardService\StructType\KanbanCardServiceTransferCardInput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get projectId value
     * @return int|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param int $projectId
     * @return \KanbanCardService\StructType\KanbanCardServiceTransferCardInput
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: int
        if (!is_null($projectId) && !is_numeric($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get destinationProjectId value
     * @return int|null
     */
    public function getDestinationProjectId()
    {
        return $this->destinationProjectId;
    }
    /**
     * Set destinationProjectId value
     * @param int $destinationProjectId
     * @return \KanbanCardService\StructType\KanbanCardServiceTransferCardInput
     */
    public function setDestinationProjectId($destinationProjectId = null)
    {
        // validation for constraint: int
        if (!is_null($destinationProjectId) && !is_numeric($destinationProjectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationProjectId)), __LINE__);
        }
        $this->destinationProjectId = $destinationProjectId;
        return $this;
    }
    /**
     * Get destinationSwimId value
     * @return int|null
     */
    public function getDestinationSwimId()
    {
        return $this->destinationSwimId;
    }
    /**
     * Set destinationSwimId value
     * @param int $destinationSwimId
     * @return \KanbanCardService\StructType\KanbanCardServiceTransferCardInput
     */
    public function setDestinationSwimId($destinationSwimId = null)
    {
        // validation for constraint: int
        if (!is_null($destinationSwimId) && !is_numeric($destinationSwimId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationSwimId)), __LINE__);
        }
        $this->destinationSwimId = $destinationSwimId;
        return $this;
    }
    /**
     * Get destinationQueueId value
     * @return int|null
     */
    public function getDestinationQueueId()
    {
        return $this->destinationQueueId;
    }
    /**
     * Set destinationQueueId value
     * @param int $destinationQueueId
     * @return \KanbanCardService\StructType\KanbanCardServiceTransferCardInput
     */
    public function setDestinationQueueId($destinationQueueId = null)
    {
        // validation for constraint: int
        if (!is_null($destinationQueueId) && !is_numeric($destinationQueueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationQueueId)), __LINE__);
        }
        $this->destinationQueueId = $destinationQueueId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceTransferCardInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
