<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for moveMultipleCardOnBoardInput StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceMoveMultipleCardOnBoardInput extends AbstractStructBase
{
    /**
     * The card
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \KanbanCardService\StructType\KanbanCardServiceCard[]
     */
    public $card;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * Constructor method for moveMultipleCardOnBoardInput
     * @uses KanbanCardServiceMoveMultipleCardOnBoardInput::setCard()
     * @uses KanbanCardServiceMoveMultipleCardOnBoardInput::setUserLoginId()
     * @param \KanbanCardService\StructType\KanbanCardServiceCard[] $card
     * @param string $userLoginId
     */
    public function __construct(array $card = array(), $userLoginId = null)
    {
        $this
            ->setCard($card)
            ->setUserLoginId($userLoginId);
    }
    /**
     * Get card value
     * @return \KanbanCardService\StructType\KanbanCardServiceCard[]
     */
    public function getCard()
    {
        return $this->card;
    }
    /**
     * Set card value
     * @throws \InvalidArgumentException
     * @param \KanbanCardService\StructType\KanbanCardServiceCard[] $card
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardInput
     */
    public function setCard(array $card = array())
    {
        foreach ($card as $moveMultipleCardOnBoardInputCardItem) {
            // validation for constraint: itemType
            if (!$moveMultipleCardOnBoardInputCardItem instanceof \KanbanCardService\StructType\KanbanCardServiceCard) {
                throw new \InvalidArgumentException(sprintf('The card property can only contain items of \KanbanCardService\StructType\KanbanCardServiceCard, "%s" given', is_object($moveMultipleCardOnBoardInputCardItem) ? get_class($moveMultipleCardOnBoardInputCardItem) : gettype($moveMultipleCardOnBoardInputCardItem)), __LINE__);
            }
        }
        $this->card = $card;
        return $this;
    }
    /**
     * Add item to card value
     * @throws \InvalidArgumentException
     * @param \KanbanCardService\StructType\KanbanCardServiceCard $item
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardInput
     */
    public function addToCard(\KanbanCardService\StructType\KanbanCardServiceCard $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KanbanCardService\StructType\KanbanCardServiceCard) {
            throw new \InvalidArgumentException(sprintf('The card property can only contain items of \KanbanCardService\StructType\KanbanCardServiceCard, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->card[] = $item;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardInput
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveMultipleCardOnBoardInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
