<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for moveCardOnBoardDetails StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceMoveCardOnBoardDetails extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The cardUniqueId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardUniqueId;
    /**
     * The fromQkeyId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $fromQkeyId;
    /**
     * The toQkeyId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $toQkeyId;
    /**
     * The fromSwimId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $fromSwimId;
    /**
     * The toSwimId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $toSwimId;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * Constructor method for moveCardOnBoardDetails
     * @uses KanbanCardServiceMoveCardOnBoardDetails::setProjectId()
     * @uses KanbanCardServiceMoveCardOnBoardDetails::setCardType()
     * @uses KanbanCardServiceMoveCardOnBoardDetails::setCardUniqueId()
     * @uses KanbanCardServiceMoveCardOnBoardDetails::setFromQkeyId()
     * @uses KanbanCardServiceMoveCardOnBoardDetails::setToQkeyId()
     * @uses KanbanCardServiceMoveCardOnBoardDetails::setFromSwimId()
     * @uses KanbanCardServiceMoveCardOnBoardDetails::setToSwimId()
     * @uses KanbanCardServiceMoveCardOnBoardDetails::setUserLoginId()
     * @param string $projectId
     * @param string $cardType
     * @param string $cardUniqueId
     * @param string $fromQkeyId
     * @param string $toQkeyId
     * @param string $fromSwimId
     * @param string $toSwimId
     * @param string $userLoginId
     */
    public function __construct($projectId = null, $cardType = null, $cardUniqueId = null, $fromQkeyId = null, $toQkeyId = null, $fromSwimId = null, $toSwimId = null, $userLoginId = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setCardUniqueId($cardUniqueId)
            ->setFromQkeyId($fromQkeyId)
            ->setToQkeyId($toQkeyId)
            ->setFromSwimId($fromSwimId)
            ->setToSwimId($toSwimId)
            ->setUserLoginId($userLoginId);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get cardUniqueId value
     * @return string|null
     */
    public function getCardUniqueId()
    {
        return $this->cardUniqueId;
    }
    /**
     * Set cardUniqueId value
     * @param string $cardUniqueId
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public function setCardUniqueId($cardUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($cardUniqueId) && !is_string($cardUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardUniqueId)), __LINE__);
        }
        $this->cardUniqueId = $cardUniqueId;
        return $this;
    }
    /**
     * Get fromQkeyId value
     * @return string|null
     */
    public function getFromQkeyId()
    {
        return $this->fromQkeyId;
    }
    /**
     * Set fromQkeyId value
     * @param string $fromQkeyId
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public function setFromQkeyId($fromQkeyId = null)
    {
        // validation for constraint: string
        if (!is_null($fromQkeyId) && !is_string($fromQkeyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromQkeyId)), __LINE__);
        }
        $this->fromQkeyId = $fromQkeyId;
        return $this;
    }
    /**
     * Get toQkeyId value
     * @return string|null
     */
    public function getToQkeyId()
    {
        return $this->toQkeyId;
    }
    /**
     * Set toQkeyId value
     * @param string $toQkeyId
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public function setToQkeyId($toQkeyId = null)
    {
        // validation for constraint: string
        if (!is_null($toQkeyId) && !is_string($toQkeyId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toQkeyId)), __LINE__);
        }
        $this->toQkeyId = $toQkeyId;
        return $this;
    }
    /**
     * Get fromSwimId value
     * @return string|null
     */
    public function getFromSwimId()
    {
        return $this->fromSwimId;
    }
    /**
     * Set fromSwimId value
     * @param string $fromSwimId
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public function setFromSwimId($fromSwimId = null)
    {
        // validation for constraint: string
        if (!is_null($fromSwimId) && !is_string($fromSwimId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fromSwimId)), __LINE__);
        }
        $this->fromSwimId = $fromSwimId;
        return $this;
    }
    /**
     * Get toSwimId value
     * @return string|null
     */
    public function getToSwimId()
    {
        return $this->toSwimId;
    }
    /**
     * Set toSwimId value
     * @param string $toSwimId
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public function setToSwimId($toSwimId = null)
    {
        // validation for constraint: string
        if (!is_null($toSwimId) && !is_string($toSwimId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($toSwimId)), __LINE__);
        }
        $this->toSwimId = $toSwimId;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceMoveCardOnBoardDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
