<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCardsByFilterInput StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceGetCardsByFilterInput extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The FilterType
     * @var \KanbanCardService\StructType\KanbanCardServiceFilterType
     */
    public $FilterType;
    /**
     * Constructor method for getCardsByFilterInput
     * @uses KanbanCardServiceGetCardsByFilterInput::setProjectId()
     * @uses KanbanCardServiceGetCardsByFilterInput::setUserLoginId()
     * @uses KanbanCardServiceGetCardsByFilterInput::setCardType()
     * @uses KanbanCardServiceGetCardsByFilterInput::setFilterType()
     * @param string $projectId
     * @param string $userLoginId
     * @param string $cardType
     * @param \KanbanCardService\StructType\KanbanCardServiceFilterType $filterType
     */
    public function __construct($projectId = null, $userLoginId = null, $cardType = null, \KanbanCardService\StructType\KanbanCardServiceFilterType $filterType = null)
    {
        $this
            ->setProjectId($projectId)
            ->setUserLoginId($userLoginId)
            ->setCardType($cardType)
            ->setFilterType($filterType);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterInput
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterInput
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterInput
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get FilterType value
     * @return \KanbanCardService\StructType\KanbanCardServiceFilterType|null
     */
    public function getFilterType()
    {
        return $this->FilterType;
    }
    /**
     * Set FilterType value
     * @param \KanbanCardService\StructType\KanbanCardServiceFilterType $filterType
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterInput
     */
    public function setFilterType(\KanbanCardService\StructType\KanbanCardServiceFilterType $filterType = null)
    {
        $this->FilterType = $filterType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardsByFilterInput
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
