<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for getCardDetailsRequest StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceGetCardDetailsRequest extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardUniqueId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardUniqueId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * The FieldNames
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $FieldNames;
    /**
     * Constructor method for getCardDetailsRequest
     * @uses KanbanCardServiceGetCardDetailsRequest::setProjectId()
     * @uses KanbanCardServiceGetCardDetailsRequest::setCardUniqueId()
     * @uses KanbanCardServiceGetCardDetailsRequest::setCardType()
     * @uses KanbanCardServiceGetCardDetailsRequest::setUserLoginId()
     * @uses KanbanCardServiceGetCardDetailsRequest::setFieldNames()
     * @param string $projectId
     * @param string $cardUniqueId
     * @param string $cardType
     * @param string $userLoginId
     * @param string[] $fieldNames
     */
    public function __construct($projectId = null, $cardUniqueId = null, $cardType = null, $userLoginId = null, array $fieldNames = array())
    {
        $this
            ->setProjectId($projectId)
            ->setCardUniqueId($cardUniqueId)
            ->setCardType($cardType)
            ->setUserLoginId($userLoginId)
            ->setFieldNames($fieldNames);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardUniqueId value
     * @return string|null
     */
    public function getCardUniqueId()
    {
        return $this->cardUniqueId;
    }
    /**
     * Set cardUniqueId value
     * @param string $cardUniqueId
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest
     */
    public function setCardUniqueId($cardUniqueId = null)
    {
        // validation for constraint: string
        if (!is_null($cardUniqueId) && !is_string($cardUniqueId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardUniqueId)), __LINE__);
        }
        $this->cardUniqueId = $cardUniqueId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Get FieldNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getFieldNames()
    {
        return isset($this->FieldNames) ? $this->FieldNames : null;
    }
    /**
     * Set FieldNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $fieldNames
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest
     */
    public function setFieldNames(array $fieldNames = array())
    {
        foreach ($fieldNames as $getCardDetailsRequestFieldNamesItem) {
            // validation for constraint: itemType
            if (!is_string($getCardDetailsRequestFieldNamesItem)) {
                throw new \InvalidArgumentException(sprintf('The FieldNames property can only contain items of string, "%s" given', is_object($getCardDetailsRequestFieldNamesItem) ? get_class($getCardDetailsRequestFieldNamesItem) : gettype($getCardDetailsRequestFieldNamesItem)), __LINE__);
            }
        }
        if (is_null($fieldNames) || (is_array($fieldNames) && empty($fieldNames))) {
            unset($this->FieldNames);
        } else {
            $this->FieldNames = $fieldNames;
        }
        return $this;
    }
    /**
     * Add item to FieldNames value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest
     */
    public function addToFieldNames($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The FieldNames property can only contain items of string, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FieldNames[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceGetCardDetailsRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
