<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for filterGroupType StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceFilterGroupType extends AbstractStructBase
{
    /**
     * The FilterAttribute
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType[]
     */
    public $FilterAttribute;
    /**
     * The op
     * @var string
     */
    public $op;
    /**
     * Constructor method for filterGroupType
     * @uses KanbanCardServiceFilterGroupType::setFilterAttribute()
     * @uses KanbanCardServiceFilterGroupType::setOp()
     * @param \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType[] $filterAttribute
     * @param string $op
     */
    public function __construct(array $filterAttribute = array(), $op = null)
    {
        $this
            ->setFilterAttribute($filterAttribute)
            ->setOp($op);
    }
    /**
     * Get FilterAttribute value
     * @return \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType[]
     */
    public function getFilterAttribute()
    {
        return $this->FilterAttribute;
    }
    /**
     * Set FilterAttribute value
     * @throws \InvalidArgumentException
     * @param \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType[] $filterAttribute
     * @return \KanbanCardService\StructType\KanbanCardServiceFilterGroupType
     */
    public function setFilterAttribute(array $filterAttribute = array())
    {
        foreach ($filterAttribute as $filterGroupTypeFilterAttributeItem) {
            // validation for constraint: itemType
            if (!$filterGroupTypeFilterAttributeItem instanceof \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType) {
                throw new \InvalidArgumentException(sprintf('The FilterAttribute property can only contain items of \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType, "%s" given', is_object($filterGroupTypeFilterAttributeItem) ? get_class($filterGroupTypeFilterAttributeItem) : gettype($filterGroupTypeFilterAttributeItem)), __LINE__);
            }
        }
        $this->FilterAttribute = $filterAttribute;
        return $this;
    }
    /**
     * Add item to FilterAttribute value
     * @throws \InvalidArgumentException
     * @param \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType $item
     * @return \KanbanCardService\StructType\KanbanCardServiceFilterGroupType
     */
    public function addToFilterAttribute(\KanbanCardService\StructType\KanbanCardServiceFilterAttributeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType) {
            throw new \InvalidArgumentException(sprintf('The FilterAttribute property can only contain items of \KanbanCardService\StructType\KanbanCardServiceFilterAttributeType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FilterAttribute[] = $item;
        return $this;
    }
    /**
     * Get op value
     * @return string|null
     */
    public function getOp()
    {
        return $this->op;
    }
    /**
     * Set op value
     * @param string $op
     * @return \KanbanCardService\StructType\KanbanCardServiceFilterGroupType
     */
    public function setOp($op = null)
    {
        // validation for constraint: string
        if (!is_null($op) && !is_string($op)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($op)), __LINE__);
        }
        $this->op = $op;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceFilterGroupType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
