<?php

namespace KanbanCardService\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for addCardDetails StructType
 * @package KanbanCardService
 * @subpackage Structs
 */
class KanbanCardServiceAddCardDetails extends AbstractStructBase
{
    /**
     * The projectId
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $projectId;
    /**
     * The cardType
     * Meta informations extracted from the WSDL
     * - nillable: false
     * @var string
     */
    public $cardType;
    /**
     * The userLoginId
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $userLoginId;
    /**
     * The mode
     * Meta informations extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $mode;
    /**
     * The fields
     * @var \KanbanCardService\StructType\KanbanCardServiceFieldsType
     */
    public $fields;
    /**
     * Constructor method for addCardDetails
     * @uses KanbanCardServiceAddCardDetails::setProjectId()
     * @uses KanbanCardServiceAddCardDetails::setCardType()
     * @uses KanbanCardServiceAddCardDetails::setUserLoginId()
     * @uses KanbanCardServiceAddCardDetails::setMode()
     * @uses KanbanCardServiceAddCardDetails::setFields()
     * @param string $projectId
     * @param string $cardType
     * @param string $userLoginId
     * @param string $mode
     * @param \KanbanCardService\StructType\KanbanCardServiceFieldsType $fields
     */
    public function __construct($projectId = null, $cardType = null, $userLoginId = null, $mode = null, \KanbanCardService\StructType\KanbanCardServiceFieldsType $fields = null)
    {
        $this
            ->setProjectId($projectId)
            ->setCardType($cardType)
            ->setUserLoginId($userLoginId)
            ->setMode($mode)
            ->setFields($fields);
    }
    /**
     * Get projectId value
     * @return string|null
     */
    public function getProjectId()
    {
        return $this->projectId;
    }
    /**
     * Set projectId value
     * @param string $projectId
     * @return \KanbanCardService\StructType\KanbanCardServiceAddCardDetails
     */
    public function setProjectId($projectId = null)
    {
        // validation for constraint: string
        if (!is_null($projectId) && !is_string($projectId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($projectId)), __LINE__);
        }
        $this->projectId = $projectId;
        return $this;
    }
    /**
     * Get cardType value
     * @return string|null
     */
    public function getCardType()
    {
        return $this->cardType;
    }
    /**
     * Set cardType value
     * @param string $cardType
     * @return \KanbanCardService\StructType\KanbanCardServiceAddCardDetails
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cardType)), __LINE__);
        }
        $this->cardType = $cardType;
        return $this;
    }
    /**
     * Get userLoginId value
     * @return string|null
     */
    public function getUserLoginId()
    {
        return $this->userLoginId;
    }
    /**
     * Set userLoginId value
     * @param string $userLoginId
     * @return \KanbanCardService\StructType\KanbanCardServiceAddCardDetails
     */
    public function setUserLoginId($userLoginId = null)
    {
        // validation for constraint: string
        if (!is_null($userLoginId) && !is_string($userLoginId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userLoginId)), __LINE__);
        }
        $this->userLoginId = $userLoginId;
        return $this;
    }
    /**
     * Get mode value
     * @return string|null
     */
    public function getMode()
    {
        return $this->mode;
    }
    /**
     * Set mode value
     * @param string $mode
     * @return \KanbanCardService\StructType\KanbanCardServiceAddCardDetails
     */
    public function setMode($mode = null)
    {
        // validation for constraint: string
        if (!is_null($mode) && !is_string($mode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mode)), __LINE__);
        }
        $this->mode = $mode;
        return $this;
    }
    /**
     * Get fields value
     * @return \KanbanCardService\StructType\KanbanCardServiceFieldsType|null
     */
    public function getFields()
    {
        return $this->fields;
    }
    /**
     * Set fields value
     * @param \KanbanCardService\StructType\KanbanCardServiceFieldsType $fields
     * @return \KanbanCardService\StructType\KanbanCardServiceAddCardDetails
     */
    public function setFields(\KanbanCardService\StructType\KanbanCardServiceFieldsType $fields = null)
    {
        $this->fields = $fields;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \KanbanCardService\StructType\KanbanCardServiceAddCardDetails
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
