<?php

namespace KanbanCardService\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unblock ServiceType
 * @package KanbanCardService
 * @subpackage Services
 */
class KanbanCardServiceUnblock extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named unblockCard
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \KanbanCardService\StructType\KanbanCardServiceUnblockCardDetails $part1
     * @return \KanbanCardService\StructType\KanbanCardServiceUnblockCardResponse|bool
     */
    public function unblockCard(\KanbanCardService\StructType\KanbanCardServiceUnblockCardDetails $part1)
    {
        try {
            $this->setResult(self::getSoapClient()->unblockCard($part1));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \KanbanCardService\StructType\KanbanCardServiceUnblockCardResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
